% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{build_report}
\alias{build_report}
\title{Build HTML report}
\usage{
build_report(
  endpoint = c("VO2max", "Flow-mediated Dilation", "BMI", "Body Mass", "Body Fat",
    "Systolic Blood Pressure", "Diastolic Blood Pressure", "HDL", "LDL", "Triglycerides",
    "Total Cholesterol", "C-reactive Protein", "Fasting Insulin", "Fasting Glucose",
    "HbA1c", "HOMA-IR"),
  path,
  format = ".html"
)
}
\arguments{
\item{endpoint}{The clinical endpoint to build the HTML report.}

\item{path}{Path to write to. It has to be a character string indicating the path and file name (without the extension). For example, \verb{~/Documents/metabolic_report} will save \code{metabolic_report.html} to the \code{Documents} folder.}

\item{format}{The file extension that you want to build the report with. Only \code{.html}, is supported.}
}
\value{
an HTML file.
}
\description{
Build an HTML report with all the results from the chosen clinical endpoint
}
\examples{
if(interactive()) {
# Build an HTML report on VO2max
build_report(endpoint = "VO2max", path = tempfile())
}
}
