% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxmap--arrange.R
\name{arrange_obs}
\alias{arrange_obs}
\title{Sort columns of \code{\link{taxmap}} objects}
\usage{
arrange_obs(.data, ...)
}
\arguments{
\item{.data}{\code{\link{taxmap}}}

\item{...}{One or more column names to sort on.}
}
\value{
An object of type \code{\link{taxmap}}
}
\description{
Sort columns of \code{obs_data} in \code{\link{taxmap}} objects. Any column name that
appears in \code{obs_data(.data)} can be used as if it was a vector on its own. See
\link[dplyr]{arrange} for more details.
}
\examples{
# Sort observations by sequence name alphabetically
arrange_obs(unite_ex_data_3, seq_name)
# Reverse order of sort
arrange_obs(unite_ex_data_3, desc(seq_name))

}
\seealso{
Other dplyr-like functions: \code{\link{arrange_taxa}},
  \code{\link{filter_obs}}, \code{\link{filter_taxa}},
  \code{\link{mutate_obs}}, \code{\link{mutate_taxa}},
  \code{\link{sample_frac_obs}},
  \code{\link{sample_frac_taxa}},
  \code{\link{sample_n_obs}}, \code{\link{sample_n_taxa}},
  \code{\link{select_obs}}, \code{\link{select_taxa}},
  \code{\link{transmute_obs}}, \code{\link{transmute_taxa}}
}

