% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/old_taxa--taxonomy--docs.R
\name{n_subtaxa_1}
\alias{n_subtaxa_1}
\title{Get number of subtaxa}
\arguments{
\item{obj}{([taxonomy()] or [taxmap()])}
}
\value{
\code{numeric}
}
\description{
Get number of subtaxa for each taxon in an object of type
[taxonomy()] or [taxmap()], not including subtaxa of subtaxa etc. This does not
include subtaxa assigned to subtaxa.
\preformatted{
obj$n_subtaxa_1()
n_subtaxa_1(obj)}
}
\examples{
# Count number of immediate subtaxa in each taxon
n_subtaxa_1(ex_taxmap)

# Filter taxa based on number of subtaxa
#  (this command removed all leaves or "tips" of the tree)
filter_taxa(ex_taxmap, n_subtaxa_1 > 0)

}
\seealso{
Other taxonomy data functions: 
\code{\link{classifications}()},
\code{\link{id_classifications}()},
\code{\link{is_branch}()},
\code{\link{is_internode}()},
\code{\link{is_leaf}()},
\code{\link{is_root}()},
\code{\link{is_stem}()},
\code{\link{map_data_}()},
\code{\link{map_data}()},
\code{\link{n_leaves_1}()},
\code{\link{n_leaves}()},
\code{\link{n_subtaxa}()},
\code{\link{n_supertaxa_1}()},
\code{\link{n_supertaxa}()},
\code{\link{taxon_ids}()},
\code{\link{taxon_indexes}()},
\code{\link{taxon_names}()},
\code{\link{taxon_ranks}()}
}
\concept{taxonomy data functions}
