% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/old_taxa--taxmap--docs.R
\name{select_obs}
\alias{select_obs}
\title{Subset columns in a [taxmap()] object}
\arguments{
\item{obj}{An object of type [taxmap()]}

\item{data}{Dataset names, indexes, or a logical vector that indicates which tables in
`obj$data` to subset columns in. Multiple tables can be subset at once.}

\item{...}{One or more column names to return in the new object. Each can be
one of two things: \describe{ \item{expression with unquoted column
name}{The name of a column in the dataset typed as if it was
a variable on its own.} \item{`numeric`}{Indexes of columns in
the dataset} } To match column names with a character vector,
use `matches("my_col_name")`. To match a logical vector, convert it to
a column index using `which`.}

\item{target}{DEPRECIATED. use "data" instead.}
}
\value{
An object of type [taxmap()]
}
\description{
Subsets columns in a [taxmap()] object. Takes and returns a
[taxmap()] object. Any variable name that appears in
[all_names()] can be used as if it was a vector on its own. See
[dplyr::select()] for the inspiration for this function and more
information. Calling the function using the `obj$select_obs(...)` style
edits "obj" in place, unlike most R functions. However, calling the function
using the `select_obs(obj, ...)` imitates R's traditional copy-on-modify
semantics, so "obj" would not be changed; instead a changed version would be
returned, like most R functions.
\preformatted{
obj$select_obs(data, ...)
select_obs(obj, data, ...)}
}
\examples{
# Selecting a column by name
select_obs(ex_taxmap, "info", dangerous)

# Selecting a column by index
select_obs(ex_taxmap, "info", 3)

# Selecting a column by regular expressions
select_obs(ex_taxmap, "info", matches("^n"))

}
\seealso{
Other taxmap manipulation functions: 
\code{\link{arrange_obs}()},
\code{\link{arrange_taxa}()},
\code{\link{filter_obs}()},
\code{\link{filter_taxa}()},
\code{\link{mutate_obs}()},
\code{\link{sample_frac_obs}()},
\code{\link{sample_frac_taxa}()},
\code{\link{sample_n_obs}()},
\code{\link{sample_n_taxa}()},
\code{\link{transmute_obs}()}
}
\concept{taxmap manipulation functions}
