% Generated by roxygen2 (4.0.1): do not edit by hand
\name{plot_correlation_between_returns}
\alias{plot_correlation_between_returns}
\title{Plot correlation of returns (i.e. metapopulation abundance) across stocks.}
\usage{
plot_correlation_between_returns(x, burn = 1:30,
  pal = rev(gg_color_hue(x$n_pop)),
  xlab = "log of return abundance by population",
  ylab = "log of return abundance by population")
}
\arguments{
  \item{x}{A list output object from
  \code{\link{meta_sim}}.}

  \item{burn}{Number of years to discard at start as burn
  in.}

  \item{pal}{Colours to label each stock/asset.}

  \item{xlab}{X axis label}

  \item{ylab}{Y axis label}
}
\description{
Create a matrix plot showing the correlation between the
log returns of each stock/asset.
}
\examples{
arma_env_params <- list(mean_value = 16, ar = 0.1, sigma_env = 2, ma = 0)
base1 <- meta_sim(n_pop = 10, env_params = arma_env_params, env_type =
  "arma", assess_freq = 5)
plot_correlation_between_returns(base1)
}

