% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/figure_add.R
\name{figure_add}
\alias{figure_add}
\title{Manually add/detect points to a scatter plot figure.}
\usage{
figure_add(file = file.choose(), color = "#009900", size = 0.03)
}
\arguments{
\item{file}{The file name and location of a scatter plot figure.  Prompts
for file name if none is explicitly called.  Can also be a binary figure 
image with detected points (an \code{EBImage} object).  
See: \code{\link{figure_detectAllPoints}}}

\item{color}{The color to paint the manually detected points; default is 
green.}

\item{size}{The radius of the painted points.}
}
\value{
A data frame with detected points.
}
\description{
Allows for the user to manually add an unlimited number of points to a 
figure image, by left-clicking over a figure's point.  Click on the red  
upper-right box called "EXIT" to end recording the position of manually 
detected points.
}
\seealso{
\link{figure_detectAllPoints}
}
