% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmt.R
\name{fmt_est}
\alias{fmt_est}
\title{Format model estimator}
\usage{
fmt_est(
  mean,
  sd = rep(NA, length(mean)),
  digits = c(1, 1),
  width = c(4, 3) + digits
)
}
\arguments{
\item{mean}{A numeric vector of mean value.}

\item{sd}{A numeric vector of sd value.}

\item{digits}{Digits of each column, i.e., format as x.x (x.xx).}

\item{width}{Width of each column.}
}
\value{
The same data frame with additional attributes for page features.
}
\description{
Formats mean sd/se to a format as x.x or x.x (x.xx) if both
mean and sd/sd are defined.
}
\details{
The function assumes 1 column or 2 columns:
\itemize{
\item If there is only 1 column, only represent mean.
\item If there are 2 columns, represent mean (sd) or mean(se).
Decimals will understand the number will be formatted as x.x (x.xx).
}
}
\section{Specification}{

\if{latex}{
 \itemize{
   \item Check all argument types and possible values.
   \item Add attributes into \code{tbl}.
 }
 }
\if{html}{The contents of this section are shown in PDF user manual only.}
}

\examples{
library(dplyr)

x <- datasets::iris |>
  summarise(
    mean = mean(Petal.Length),
    n = n(),
    sd = sd(Petal.Length)
  )
fmt_est(x$mean, x$sd)
}
