% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extend_ae_summary_eaer.R
\name{extend_ae_summary_eaer}
\alias{extend_ae_summary_eaer}
\title{Add exposure-adjusted rate information for AE summary analysis}
\usage{
extend_ae_summary_eaer(
  outdata,
  duration_var = "TRTDUR",
  adj_unit = c("year", "month", "week", "day")
)
}
\arguments{
\item{outdata}{An \code{outdata} object created by \code{\link[=prepare_ae_summary]{prepare_ae_summary()}}.}

\item{duration_var}{A character value of duration variable name.
By default, \code{"TRTDUR"} is used.}

\item{adj_unit}{A character value of exposure adjusted unit.
It could be select from \code{"year"}, \code{"month"}, \code{"week"}, and \code{"day"}.}
}
\value{
A list of analysis raw datasets.
}
\description{
Add exposure-adjusted rate information for AE summary analysis
}
\examples{
meta <- meta_ae_example()
prepare_ae_summary(
  meta,
  population = "apat",
  observation = "wk12",
  parameter = "any;rel;ser"
) |>
  extend_ae_summary_eaer()
}
