% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_base_char_subgroup.R
\name{prepare_base_char_subgroup}
\alias{prepare_base_char_subgroup}
\title{Prepare data for treatment compliance table}
\usage{
prepare_base_char_subgroup(
  meta,
  population,
  analysis = "base_char_subgroup",
  parameter,
  subgroup_var,
  subgroup_header = c(meta$population[[population]]$group, subgroup_var),
  display_subgroup_total = TRUE
)
}
\arguments{
\item{meta}{A metadata object created by metalite.}

\item{population}{A character value of population term name.
The term name is used as key to link information.}

\item{analysis}{A character value of analysis term name.
The term name is used as key to link information.}

\item{parameter}{A character value of parameter term name.
The term name is used as key to link information.}

\item{subgroup_var}{A character value of subgroup variable name in
observation data saved in \code{meta$data_observation}.}

\item{subgroup_header}{A character vector for column header hierarchy.
The first element will be the first level header and the second element
will be second level header.}

\item{display_subgroup_total}{A logic value of displaying the total group.}
}
\value{
A list of analysis raw datasets.
}
\description{
Prepare data for treatment compliance table
}
\examples{
meta <- meta_sl_example()
outdata <- prepare_base_char_subgroup(
  meta,
  population = "apat",
  parameter = "age",
  subgroup_var = "TRTA",
  subgroup_header = c("SEX", "TRTA"),
  display_subgroup_total = TRUE
)
}
