% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtf_base_char_subgroup.R
\name{rtf_base_char_subgroup}
\alias{rtf_base_char_subgroup}
\title{Subgroup Analysis for Baseline Characteristic}
\usage{
rtf_base_char_subgroup(
  outdata,
  source,
  col_rel_width = NULL,
  text_font_size = 8,
  orientation = "landscape",
  footnotes = NULL,
  title = NULL,
  path_outdata = NULL,
  path_outtable = NULL
)
}
\arguments{
\item{outdata}{An \code{outdata} object created by \code{\link[=prepare_base_char_subgroup]{prepare_base_char_subgroup()}}}

\item{source}{A character value of the data source.}

\item{col_rel_width}{Column relative width in a vector e.g. c(2,1,1) refers to 2:1:1.
Default is NULL for equal column width.}

\item{text_font_size}{Text font size.  To vary text font size by column, use
numeric vector with length of vector equal to number of columns
displayed e.g. c(9,20,40).}

\item{orientation}{Orientation in 'portrait' or 'landscape'.}

\item{footnotes}{A character vector of table footnotes.}

\item{title}{Term "analysis", "observation" and "population") for collecting title from metadata or a character vector of table titles.}

\item{path_outdata}{A character string of the outdata path.}

\item{path_outtable}{A character string of the outtable path.}
}
\value{
RTF file and source dataset for baseline characteristic table.
}
\description{
Subgroup Analysis for Baseline Characteristic
}
\examples{
\donttest{
meta <- meta_sl_example()

outdata <- prepare_base_char_subgroup(
  meta,
  population = "apat",
  parameter = "age",
  subgroup_var = "TRTA",
  subgroup_header = c("SEX", "TRTA"),
  display_subgroup_total = TRUE
)

outdata |>
  format_base_char_subgroup() |>
  rtf_base_char_subgroup(
    source = "Source:  [CDISCpilot: adam-adsl]",
    path_outdata = tempfile(fileext = ".Rdata"),
    path_outtable = tempfile(fileext = ".rtf")
  )
}
}
