% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label.R
\name{assign_label}
\alias{assign_label}
\title{A function to assign labels to a data frame}
\usage{
assign_label(data, var = names(data), label = names(data))
}
\arguments{
\item{data}{A data frame.}

\item{var}{The variables to assign labels.}

\item{label}{The labels to be assigned.}
}
\value{
A data frame with labels updated.
}
\description{
A function to assign labels to a data frame
}
\details{
\itemize{
\item Case 1:
If the variable's label is already define in the original data frame
but not redefined in \code{assign_label(...)}, its original labels will be kept.
\item Case 2:
If the variable's label is already define in the original data frame
but re-defined by \code{assign_label(...)}, its labels will be re-defined.
\item Case 3:
If the variable's label is not define in the original data frame
but it is defined by \code{assign_label(...)}, its labels will added.
\item Case 4:
If the variable's label is not define in the original data frame,
neither was it defined by \code{assign_label(...)}, its labels will be the
variable name itself.
}
}
\examples{
assign_label(r2rtf::r2rtf_adae) |> head()
assign_label(
  r2rtf::r2rtf_adae,
  var = "USUBJID",
  label = "Unique subject identifier"
) |> head()
}
