% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool.med.R
\name{pool.med}
\alias{pool.med}
\title{Meta-Analysis via median of (the difference of) medians method}
\usage{
pool.med(yi, wi, norm.approx = TRUE)
}
\arguments{
\item{yi}{vector of the study-specific effect sizes (e.g., the medians or the difference of medians)}

\item{wi}{optional vector of positive, study-specific weights (e.g., sample sizes)}

\item{norm.approx}{optional logical scalar indicating whether normality approximation of the binomial should be used to construct an approximate 95\% confidence interval (the default is \code{TRUE}).}
}
\value{
A list with components
\item{pooled.est}{Pooled estimate}
\item{ci.lb}{Lower bound of confidence interval}
\item{ci.ub}{Upper bound of confidence interval}
\item{cov.level}{Theoretical coverage of the confidence interval around the pooled estimate. When \code{norm.approx} is set to \code{TRUE}, the theoretical coverage is 95\%. When \code{norm.approx} is set to \code{FALSE}, the theoretical coverage is set to the smallest possible value greater than 95\%.}
}
\description{
This function meta-analyzes the study-specific effect sizes by applying the (weighted) median of medians method (McGrath et al., 2018a) in one-sample contexts and the (weighted) median of the difference of median method (McGrath et al., 2018b) in two-sample contexts.
}
\details{
For one-group studies, authors may report the sample median or mean. If these measures are supplied for \code{yi} and weights are not provided for \code{wi}, the function implements the median of medians (MM) method (McGrath et al., 2018a).

For two-group studies, authors may report the difference of medians or the difference of means across both groups. If these measures are supplied for \code{yi} and weights are not provided for \code{wi}, the function implements the median of the difference of medians (MDM) method (McGrath et al., 2018b).

Analogous weighted versions of the MM and MDM methods can be applied when study-specific sample sizes are provided for \code{wi}.

The confidence interval around the pooled estimate is constructed by inverting the sign test.
}
\examples{
## Storing data (study-specific difference of medians)
yi <- c(5.23, 3.10, 0.50, 0.78, 3.48, 0.59, 2.20, 5.06, 4.00)

## Meta-analysis of the difference of medians
pool.med(yi)

}
\references{
McGrath S., Zhao X., Qin Z.Z., Steele R., and Benedetti A. (2018). One-sample aggregate data meta-analysis of medians. \emph{Statistics in Medicine}. 1–16.

McGrath S., Sohn H., Steele R., and Benedetti A. (2018). Two-sample aggregate data meta-analysis of medians. \emph{ArXiv e-prints}. \url{https://arxiv.org/abs/1809.01278}.
}
