% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{moments_n}
\alias{moments_n}
\title{Compute moments}
\usage{
moments_n(orders, cols = NULL)
}
\arguments{
\item{orders}{Numeric with the order of the uncentered moments that will
be computed.}

\item{cols}{Character vector with the name of the columns of the data for which
moments will be computed. If \code{NULL}, will use all columns.}
}
\value{
A function that takes a \code{data.frame} and return a named numeric vector of the
uncentered moments of the columns.
}
\description{
Returns a function that will return uncentered moments
}
\examples{
data <- data.frame(x = rnorm(100), y = rnorm(100))
moments_3 <- moments_n(1:3)

moments_3(data)

moments_3 <- moments_n(1:3, "x")
moments_3(data)

}
\seealso{
Other helper functions: \code{\link{delayed_with}},
  \code{\link{densify}}, \code{\link{draw_data}},
  \code{\link{mean_dist_to}}
}
\concept{helper functions}
