% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oecalc.R
\name{oecalc}
\alias{oecalc}
\title{Calculate the total O:E ratio}
\usage{
oecalc(OE, OE.se, OE.cilb, OE.ciub, OE.cilv, EO, EO.se, citl, citl.se, N,
  O, E, Po, Po.se, Pe, data, slab, add = 1/2, g = NULL, level = 0.95,
  ...)
}
\arguments{
\item{OE}{vector with the estimated ratio of total observed versus total expected events}

\item{OE.se}{Optional vector with the standard errors of the estimated O:E ratios}

\item{OE.cilb}{Optional vector to specify the lower limits of the confidence interval for \code{OE}.}

\item{OE.ciub}{Optional vector to specify the upper limits of the confidence interval for \code{OE}.}

\item{OE.cilv}{Optional vector to specify the levels of aformentioned confidence interval limits. 
(default: 0.95, which corresponds to the 95\% confidence interval).}

\item{EO}{Optional vector with the estimated ratio of total expected versus total observed events}

\item{EO.se}{Optional vector with the standard errors of the estimated E:O ratios}

\item{citl}{Optional vector with the estimated calibration-in-the-large statistics}

\item{citl.se}{Optional vector with the standard error of the calibration-in-the-large statistics}

\item{N}{Optional vector to specify the sample/group sizes.}

\item{O}{Optional vector to specify the total number of observed events.}

\item{E}{Optional vector to specify the total number of expected events}

\item{Po}{Optional vector to specify the (cumulative) observed event probabilities.}

\item{Po.se}{Optional vector with the standard errors of \code{Po}.}

\item{Pe}{Optional vector to specify the (cumulative) expected event probabilites
(if specified, during time \code{t.val})}

\item{data}{Optional data frame containing the variables given to the arguments above.}

\item{slab}{Optional vector with labels for the studies.}

\item{add}{a non-negative number indicating the amount to add to zero counts. See `Details'}

\item{g}{a quoted string that is the function to transform estimates of the total O:E ratio; see the details below.}

\item{level}{level for confidence interval, default \code{0.95}.}

\item{\ldots}{Additional arguments.}
}
\value{
An object of class c("mm_perf","data.frame") with the following columns:
\describe{
 \item{"theta"}{The (transformed) O:E ratio. }
 \item{"theta.se"}{Standard errors of the (transformed) O:E ratio.}
 \item{"theta.cilb"}{Lower confidence interval of the (transformed) O:E ratios. The level is specified in
 \code{level}. Intervals are calculated on the same scale as \code{theta} by assuming a Normal distribution.}
 \item{"theta.ciub"}{Upper confidence interval of the (transformed) c-statistics. The level is specified in
 \code{level}. Intervals are calculated on the same scale as \code{theta} by assuming a Normal distribution.}
 \item{"theta.source"}{Method used for calculating the (transformed) O:E ratio.}
 \item{"theta.se.source"}{Method used for calculating the standard error of the (transformed) O:E ratio.}
}
}
\description{
This function calculates (transformed versions of) the ratio of total number of observed versus expected events with the 
corresponding sampling variance.
}
\examples{
######### Validation of prediction models with a binary outcome #########
data(EuroSCORE)

# Calculate the total O:E ratio and its standard error
est1 <- oecalc(O = n.events, E = e.events, N = n, data = EuroSCORE, slab = Study)
est1

# Calculate the log of the total O:E ratio and its standard error
est2 <- oecalc(O = n.events, E = e.events, N = n, data = EuroSCORE, slab = Study, g = "log(OE)")
est2

# Display the results of all studies in a forest plot
plot(est1)

}
\references{
Debray TPA, Damen JAAG, Snell KIE, Ensor J, Hooft L, Reitsma JB, et al. A guide to systematic review and meta-analysis of prediction model performance. BMJ. 2017;356:i6460. 

Debray TPA, Damen JAAG, Riley R, Snell KIE, Reitsma JB, Hooft L, et al. A framework for meta-analysis of  prediction model studies with binary and time-to-event outcomes. Stat Methods Med Res. 2018; In press. 

Snell KI, Ensor J, Debray TP, Moons KG, Riley RD. Meta-analysis of prediction model performance across 
multiple studies: Which scale helps ensure between-study normality for the C -statistic and calibration measures? 
\emph{Statistical Methods in Medical Research}. 2017.
}
\author{
Thomas Debray <thomas.debray@gmail.com>
}
\keyword{calibration}
\keyword{meta-analysis}
\keyword{performance}
