% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{utils_data}
\alias{utils_data}
\alias{clip_read}
\alias{clip_write}
\title{Utilities for data Copy-Pasta}
\usage{
clip_read(header = TRUE, sep = "\\t", ...)

clip_write(.data, sep = "\\t", row_names = FALSE, col_names = TRUE, ...)
}
\arguments{
\item{header}{If the copied data has a header row for dataFrame, defaults to
\code{TRUE}.}

\item{sep}{The separator which should be used in the copied output.}

\item{...}{Further arguments to be passed to \code{\link[utils:read.table]{utils::read.table()}}.}

\item{.data}{The data that should be copied to the clipboard. Only data frames and matrices are allowed}

\item{row_names}{Decides if the output should keep row names or not, defaults
to \code{FALSE}.}

\item{col_names}{Decides if the output should keep column names or not,
defaults to \code{TRUE}.}
}
\value{
Nothing
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

These functions allows interacting with the system clipboard. It is possible
read from the clipboard or write a data frame or matrix to the clipboard.
\itemize{
\item \code{clip_read()} read data from the clipboard.
\item \code{clip_write()} write data to the clipboard.
}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
