% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performs_ammi.R
\name{performs_ammi}
\alias{performs_ammi}
\title{Additive Main effects and Multiplicative Interaction}
\usage{
performs_ammi(.data, env, gen, rep, resp, block = NULL, verbose = TRUE, ...)
}
\arguments{
\item{.data}{The dataset containing the columns related to Environments,
Genotypes, replication/block and response variable(s).}

\item{env}{The name of the column that contains the levels of the
environments}

\item{gen}{The name of the column that contains the levels of the genotypes}

\item{rep}{The name of the column that contains the levels of the
replications/blocks}

\item{resp}{The response variable(s). To analyze multiple variables in a
single procedure, use comma-separated list of unquoted variable names,
i.e., \code{resp = c(var1, var2, var3)}, or any select helper like
\code{resp = contains("_PLA")}.}

\item{block}{Defaults to \code{NULL}. In this case, a randomized complete
block design is considered. If block is informed, then a resolvable
alpha-lattice design (Patterson and Williams, 1976) is employed.
\strong{All effects, except the error, are assumed to be fixed.}}

\item{verbose}{Logical argument. If \code{verbose = FALSE} the code will run
silently.}

\item{...}{Arguments passed to the function
\code{\link{impute_missing_val}()} for imputation of missing values in case
of unbalanced data.}
}
\value{
\itemize{
\item \strong{ANOVA}: The analysis of variance for the AMMI model.
\item \strong{PCA}: The principal component analysis
\item \strong{MeansGxE}: The means of genotypes in the environments
\item \strong{model}: scores for genotypes and environments in all the possible
axes.
\item \strong{augment:} Information about each observation in the dataset. This
includes predicted values in the \code{fitted} column, residuals in the
\code{resid} column, standardized residuals in the \code{stdres} column,
the diagonal of the 'hat' matrix in the \code{hat}, and standard errors for
the fitted values in the \code{se.fit} column.
}
}
\description{
Compute the Additive Main effects and Multiplicative interaction. This
function also serves as a helper function for other procedures performed in
the \pkg{metan} package such as \code{\link{waas}} and \code{\link{wsmp}}
}
\examples{
\donttest{
library(metan)
model <- performs_ammi(data_ge, ENV, GEN, REP, resp = c(GY, HM))

# PC1 x PC2 (variable GY)
p1 <- plot_scores(model)
p1

# PC1 x PC2 (variable HM)
plot_scores(model,
            var = 2, # or "HM"
            type = 2)

# Nominal yield plot (variable GY)
# Draw a convex hull polygon
plot_scores(model, type = 4)

# Unbalanced data (GEN 2 in E1 missing)
mod <-
  data_ge \%>\%
   remove_rows(4:6) \%>\%
   droplevels() \%>\%
   performs_ammi(ENV, GEN, REP, GY)
p2 <- plot_scores(mod)
arrange_ggplot(p1, p2, labels = c("Balanced data", "Unbalanced data"))

}
}
\references{
Patterson, H.D., and E.R. Williams. 1976. A new class of
resolvable incomplete block designs. Biometrika 63:83-92.
\href{https://doi.org/10.1093/biomet/63.1.83}{doi:10.1093/biomet/63.1.83}
}
\seealso{
\code{\link{impute_missing_val}}, \code{\link{waas}}, \code{\link{waas_means}}, \code{\link{waasb}}, \code{\link{get_model_data}}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
