% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{diag_label}
\alias{diag_label}
\title{Format a Diagonal Label}
\usage{
diag_label(varname, .data, diag_label_simple = metOption("diag_label_simple",
  FALSE), diag_label_split = metOption("diag_label_split", TRUE),
  diag_symbol_format = metOption("diag_symbol_format", "wikisym2plotmath"),
  verbose = metOption("verbose_diag_label", FALSE), ...)
}
\arguments{
\item{varname}{character}

\item{.data}{data.frame}

\item{diag_label_simple}{logical: just return varname?}

\item{diag_label_split}{whether to substitute line breaks for spaces}

\item{diag_symbol_format}{function to process symbol attribute, if present}

\item{verbose}{generate messages describing process}

\item{...}{ignored}
}
\value{
character
}
\description{
Formats a diagonal label. Can return a simple column name, a column label (if attribute defined), a fractured column label (split on spaces), or a processed symbol (over-rides label).
}
\seealso{
Other panel functions: \code{\link{boxplot_panel}},
  \code{\link{categorical_panel}},
  \code{\link{corsplom_gg_correlation}},
  \code{\link{corsplom_gg_diagonal}},
  \code{\link{corsplom_gg_scatter}},
  \code{\link{corsplom_panel_correlation}},
  \code{\link{corsplom_panel_diagonal}},
  \code{\link{corsplom_panel_scatter}},
  \code{\link{dens_panel}}, \code{\link{diag_pin}},
  \code{\link{iso_prepanel}}, \code{\link{metaplot_key}},
  \code{\link{metaplot_ref}},
  \code{\link{panel.meta_densityplot}},
  \code{\link{panel_tile}},
  \code{\link{scatter_panel_ref}},
  \code{\link{scatter_panel}}

Other formatters: \code{\link{wikisym2plotmath_}},
  \code{\link{wikisym2plotmath}}
}
