% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/settings_matrix.R
\name{random_removal}
\alias{random_removal}
\title{Generate random removal sequence}
\usage{
random_removal(
  columns,
  min_removed_inputs,
  max_removed_inputs,
  dropout_dist = "exponential"
)
}
\arguments{
\item{columns}{Columns of the settings_matrix that are passed in}

\item{min_removed_inputs}{The smallest number of input dataframes that may
be randomly removed.}

\item{max_removed_inputs}{The largest number of input dataframes that may be
randomly removed.}

\item{dropout_dist}{Indication of how input dataframes should be dropped.
can be "none" (no dropout), "uniform" (uniformly draw number between min
and max removed inputs), or "exponential" (like uniform, but using an
exponential distribution; default).}
}
\value{
inclusions_df Dataframe that can be rbind'ed to the settings_matrix
}
\description{
Helper function to contribute to rows within the settings matrix. Number of
columns removed follows a uniform or exponential probability distribution.
}
