% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_snf.R
\name{get_dist_matrix}
\alias{get_dist_matrix}
\title{Calculate distance matrices}
\usage{
get_dist_matrix(
  df,
  input_type,
  cnt_dist_fn,
  dsc_dist_fn,
  ord_dist_fn,
  cat_dist_fn,
  mix_dist_fn,
  weights_row
)
}
\arguments{
\item{df}{Raw data frame with subject IDs in column "uid"}

\item{input_type}{Either "numeric" (resulting in euclidean distances),
"categorical" (resulting in binary distances), or "mixed" (resulting in
gower distances)}

\item{cnt_dist_fn}{distance metric function for continuous data}

\item{dsc_dist_fn}{distance metric function for discrete data}

\item{ord_dist_fn}{distance metric function for ordinal data}

\item{cat_dist_fn}{distance metric function for categorical data}

\item{mix_dist_fn}{distance metric function for mixed data}

\item{weights_row}{Single-row data frame where the column names contain the
column names in df and the row contains the corresponding weights_row.}
}
\value{
dist_matrix Matrix of inter-observation distances.
}
\description{
Given a data frame of numerical features, return a euclidean distance matrix.
}
\keyword{internal}
