% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ari_matrix.R
\name{calc_aris}
\alias{calc_aris}
\title{Construct an ARI matrix storing inter-solution similarities}
\usage{
calc_aris(
  sol_df,
  processes = 1,
  verbose = FALSE,
  dist_method = "euclidean",
  hclust_method = "complete"
)
}
\arguments{
\item{sol_df}{Solutions data frame containing cluster solutions to calculate
pairwise ARIs for.}

\item{processes}{Specify number of processes used to complete calculations
\itemize{
\item \code{1} (default) Sequential processing
\item \code{2} or higher: Parallel processing will use the
\code{future.apply::future_apply} to distribute the calculations across
the specified number of CPU cores. If higher than the number of
available cores, a warning will be raised and the maximum number of
cores will be used.
\item \code{max}: All available cores will be used.
Note that no progress indicator is available during multi-core processing.
}}

\item{verbose}{If TRUE, output progress to console.}

\item{dist_method}{Distance method to use when calculating sorting order to
of the matrix. Argument is directly passed into stats::dist. Options
include "euclidean", "maximum", "manhattan", "canberra", "binary", or
"minkowski".}

\item{hclust_method}{Agglomerative method to use when calculating sorting
order by \code{stats::hclust}. Options include "ward.D", "ward.D2", "single",
"complete", "average", "mcquitty", "median", or "centroid".}
}
\value{
om_aris ARIs between clustering solutions of an solutions data frame
}
\description{
This function constructs an \code{ari_matrix} class object from a \code{solutions_df}
class object. The ARI matrix stores pairwise adjusted Rand indices for all
cluster solutions as well as a numeric order for the solutions data frame
based on the hierarchical clustering of the ARI matrix.
}
\examples{
dl <- data_list(
    list(subc_v, "subcortical_volume", "neuroimaging", "continuous"),
    list(pubertal, "pubertal_status", "demographics", "continuous"),
    uid = "unique_id"
)

sc <- snf_config(dl, n_solutions = 3)
sol_df <- batch_snf(dl, sc)
calc_aris(sol_df)
}
