% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viewport.R
\name{meta_viewport}
\alias{meta_viewport}
\title{Viewport Meta Tag}
\usage{
meta_viewport(
  .meta = meta(),
  width = "device-width",
  initial_scale = "1",
  orientation = c("auto", "portrait", "landscape"),
  min_width = NULL,
  max_width = NULL,
  height = NULL,
  min_height = NULL,
  max_height = NULL,
  minimum_scale = NULL,
  maximum_scale = NULL,
  user_scalable = NULL,
  ...
)
}
\arguments{
\item{.meta}{A \code{meta} object created by \code{\link[=meta]{meta()}} or \code{\link[=as_meta]{as_meta()}}, or returned
by a \verb{meta_*()} object.}

\item{width}{Sets the width of initial viewport. \code{width} sets \code{min_width} and
\code{max_width} and may contain two values; for example, the following are
equivalent: \code{"300px 500px"} or \code{c("300px", "500px")}). The values may be
a number with units, a percentage, or \code{"device-width"}. Pixels are assumed
if no units are provided.}

\item{initial_scale}{Initial scale}

\item{orientation}{One of \code{"auto"}, \code{"portrait"}, \code{"landscape"}.}

\item{min_width, max_width}{Minimum and maximum initial viewport width. See
\code{width} for more information. \code{width} is ignored if \code{min_width} or
\code{max_width} are set.}

\item{height, min_height, max_height}{Sets height of initial viewport. Follows
the same conventions as \code{width}, \code{min_width}, and \code{max_width}.}

\item{minimum_scale}{Minimum scale}

\item{maximum_scale}{Maximum scale}

\item{user_scalable}{User scalable}

\item{...}{Additional name/value pairs}
}
\value{
A \code{meta} object, or a set of \verb{<meta>} HTML tags inside an HTML
\verb{<head>} tag. For use in \code{\link[rmarkdown:html_document]{rmarkdown::html_document()}}, \code{\link[shiny:runApp]{shiny::runApp()}},
or other HTML locations.
}
\description{
Create or add a viewport meta tag.
}
\examples{
meta() \%>\%
  meta_viewport()

meta() \%>\%
  meta_viewport(orientation = NULL)

meta() \%>\%
  meta_viewport(maximum_scale = 1)

}
\references{
\href{https://developer.mozilla.org/en-US/docs/Web/HTML/Viewport_meta_tag}{MDN: Viewport Meta Tag},
\href{https://drafts.csswg.org/css-device-adapt/#viewport-meta}{W3C Viewport Meta Element Specification}
}
\seealso{
Other meta: 
\code{\link{meta_apple_itunes_app}()},
\code{\link{meta_apple_web_app}()},
\code{\link{meta_general}()},
\code{\link{meta_geo}()},
\code{\link{meta_google_scholar}()},
\code{\link{meta_name}()},
\code{\link{meta_social}()},
\code{\link{meta_tag}()},
\code{\link{meta}()}
}
\concept{meta}
