% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/union.R
\name{union.umbrella}
\alias{union.umbrella}
\title{Union of two objects of class \dQuote{umbrella}}
\usage{
union.umbrella(x, y, ...)
}
\arguments{
\item{x}{an object of class \code{umbrella}.}

\item{y}{an object of class \code{umbrella}.}

\item{...}{other arguments that can be passed to the function}
}
\value{
Returns an object of class\dQuote{umbrella}, with the factors of the two merged objects of class \dQuote{umbrella}.
}
\description{
Combines the factors included in two umbrella objects
}
\details{
This function allows to combine the results of two objects of class \dQuote{umbrella}.
This function is particularly useful when different meta-analytic models should be used for different factors.
Note that it is note possible to union two umbrella objects returned by the \code{add.evidence()} function with different criteria.
}
\examples{
\donttest{
### union raw umbrella objects
umb1 <- umbrella(df.SMD, method.var = "REML")
umb2 <- umbrella(df.OR, method.var = "PM")
umb.union <- union.umbrella(umb1, umb2)
summary(add.evidence(umb.union, criteria = "GRADE"))

### union umbrella objects after apllying stratification of evidence
umb1 <- add.evidence(umbrella(df.SMD), criteria = "GRADE")
umb2 <- add.evidence(umbrella(df.OR), criteria = "GRADE")
umb3 <- add.evidence(umbrella(df.IRR), criteria = "GRADE")
umb.union <- union.umbrella(union.umbrella(umb1, umb2), umb3)
summary(umb.union)
}
}
