% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpatialPointsMeteorology-methods.R
\name{SpatialPointsMeteorology}
\alias{SpatialPointsMeteorology}
\title{Creates a 'SpatialPointsMeteorology'}
\usage{
SpatialPointsMeteorology(points, data, dates, dataByDate = FALSE)
}
\arguments{
\item{points}{An object of class \code{SpatialPoints}. Row
names of point coordinates are used to identify points.}

\item{data}{A list of data frames. If \code{dataByDate = FALSE} the elements
of \code{data} are assumed to correspond to points. If \code{dataByDate =
TRUE} the elements of \code{data} are assumed to correspond to dates (see
'Details').}

\item{dates}{Object of class \code{"Date"} describing the time period of
meteorological estimates.}

\item{dataByDate}{A flag to indicate that elements of \code{data} correspond
to dates, as opposed to the default (\code{dataByDate = FALSE}) which
assumes that elements correspond to points (see 'Details').}
}
\value{
An object of class \code{\link{SpatialPointsMeteorology-class}}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Initializes an object of class \code{SpatialPointsMeteorology-class}
}
\details{
There are two ways of building an object of of class
\code{\link{SpatialPointsMeteorology-class}}. The first way
(\code{dataByDate = FALSE}) is to supply as value for \code{data} a vector
of data frames with one data frame per spatial point, with dates as rows and
meteorological variables as columns. In this case all data frames must have
the same number of rows (dates) and columns (variables). The second way (if
\code{dataByDate = TRUE}) is to supply as value for \code{data} a vector of
data frames with one data frame per date, with points as rows and
meteorological variables as columns. In this case, the data frames may have
different rows and different columns. Only the information corresponding to
\code{points} will be taken and some variables may be missing.
}
\seealso{
\code{\link{SpatialPointsMeteorology-class}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}
