% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_meteo_from}
\alias{get_meteo_from}
\title{Get meteorological stations data}
\usage{
get_meteo_from(
  service = c("aemet", "meteocat", "meteoclimatic", "meteogalicia", "ria"),
  options
)
}
\arguments{
\item{service}{Character with the service name (in lower case).}

\item{options}{List with the needed service options. See \code{\link{services_options}} to have more info
about the different services and their options.}
}
\value{
An sf (spatial) object with the stations meteorological data.
}
\description{
Connect and retrieve data from AEMET, SMC and other Spanish meteorological stations services.
}
\details{
Depending on the service and the temporal resolution selected, the variables present can change, but all
services have at least temperature values.
}
\section{API limits}{

Some APIs have limits in terms of the data that can be retrieved with one call. For example, AEMET
only serves daily data for 31 days in one query. See \code{vignette('api_limits', package = 'meteospain')}
for a detailed explanations of those limits and the ways to retrieve longer periods.
}

\section{Cache}{

To avoid unnecessary API calls (especially in rate-limited APIs), results are cached to
memory in a \code{\link[cachem]{cache_mem}} object. This cache is limited to the actual
R session and invalidates after 24h.
Temporal resolutions below daily are not cached, as they change often.

This cache can be cleared with \code{\link{clear_meteospain_cache}}.
}

\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
  library(meteospain)
  library(keyring)

  # AEMET (we need a key)
  # key_set('aemet')
  options_for_aemet <- aemet_options(
    'daily',
    start_date = as.Date('2012-01-16'),
    end_date = as.Date('2012-01-31'),
    api_key = key_get('aemet')
  )
  get_meteo_from('aemet', options_for_aemet)
\dontshow{\}) # examplesIf}
}
