% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errorChecker.R
\name{errorChecker}
\alias{errorChecker}
\title{Wrapper for summarizing randomizations and testing significance of observed metrics}
\usage{
errorChecker(observed, reduced.randomizations, concat.by)
}
\arguments{
\item{observed}{Data frame of observed metric scores, such as from observedMetrics()}

\item{reduced.randomizations}{List of random, reduced results, such as those from
reduceRandomizations()}

\item{concat.by}{Whether to concatenate the randomizations by richness, plot or both}
}
\value{
A list of lists of data frames.
}
\description{
Given a data frame of observed metrics and a list of randomizations based on different
null models, returns a list of data frames summarizing the significance of observed 
metrics both at the single plot and the entire arena level.
}
\details{
This function wraps a number of smaller functions into a useful type I and II
error checker. It takes a reduced list of randomizations such as those reduced from
metricsNnulls with reduceRandomizations, summarizes the mean,
SD, and CI of each metric plus null model either at the richness or plot level,
then compares the observed metric scores to those summarized metrics. It return a list
with two elements. The first is a list of data frames, where each corresponds to the 
standardized effect scores of the observed metrics for a given null model. The second
is a list of data frames, where each corresponds to whether a given plot deviates
beyond CI. For the latter, 0 corresponds to within CI, 1 corresponds to less than the
CI, and 2 corresponds to greater than the CI.
}
\examples{
#simulate tree with birth-death process
tree <- geiger::sim.bdtree(b=0.1, d=0, stop="taxa", n=50)

#simulate a log normal abundance distribution
sim.abundances <- round(rlnorm(5000, meanlog=2, sdlog=1)) + 1

#simulate a community of varying richness
cdm <- simulateComm(tree, richness.vector=10:13, abundances=sim.abundances)

#run the metrics and nulls combo function
rawResults <- metricsNnulls(tree=tree, picante.cdm=cdm, randomizations=2, cores="seq",
nulls=c("richness","frequency"), metrics=c("richness","NAW_MPD"))

#summarize the results
results <- reduceRandomizations(rawResults)

#calculate the observed metrics from the input CDM
observed <- observedMetrics(tree, cdm, metrics=c("richness", "NAW_MPD"))

test <- errorChecker(observed, results, "richness")
}
\references{
Miller, E. T., D. R. Farine, and C. H. Trisos. 2016. Phylogenetic community
structure metrics and null models: a review with new methods and software.
Ecography DOI: 10.1111/ecog.02070
}
