% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomArena.R
\name{randomArena}
\alias{randomArena}
\title{Generate a random spatial arena}
\usage{
randomArena(simulations.input)
}
\arguments{
\item{simulations.input}{A prepared simulations.input object from prepSimulations}
}
\value{
A list of 4 elements: the mean of the genetic distance matrix of the input
phylogeny, the regional abundance vector (where each element is a species name, 
repeated as many times as is present in pool), the spatial arena, and the dimensions of
that arena.
}
\description{
Given a simulations.input object, will create a randomly settled arena according to the
parameters in the simulations.input object.
}
\details{
This function uses the log-normal regional abundance distribution to randomly
assign abundances to species in the tree. It then draws from this regional abundance
distribution to settle individuals at random in the landscape.
}
\examples{
tree <- geiger::sim.bdtree(b=0.1, d=0, stop="taxa", n=50)

prepped <- prepSimulations(tree, arena.length=300, mean.log.individuals=2, 
length.parameter=5000, sd.parameter=50, max.distance=20, proportion.killed=0.2,
competition.iterations=2)

test <- randomArena(prepped)
}
\references{
Miller, E. T., D. R. Farine, and C. H. Trisos. 2016. Phylogenetic community
structure metrics and null models: a review with new methods and software.
Ecography DOI: 10.1111/ecog.02070
}
