% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_specificity.R
\name{specificity}
\alias{specificity}
\alias{FPR}
\title{Specificity}
\usage{
specificity(
  data = NULL,
  obs,
  pred,
  atom = FALSE,
  pos_level = 2,
  tidy = FALSE,
  na.rm = TRUE
)

FPR(
  data = NULL,
  obs,
  pred,
  atom = FALSE,
  pos_level = 2,
  tidy = FALSE,
  na.rm = TRUE
)
}
\arguments{
\item{data}{(Optional) argument to call an existing data frame containing the data.}

\item{obs}{Vector with observed values (character | factor).}

\item{pred}{Vector with predicted values (character | factor).}

\item{atom}{Logical operator (TRUE/FALSE) to decide if the estimate is made for
each class (atom = TRUE) or at a global level (atom = FALSE); Default : FALSE.
When dataset is "binomial" atom does not apply.}

\item{pos_level}{Integer, for binary cases, indicating the order (1|2) of the level
corresponding to the positive. Generally, the positive level is the second (2)
since following an alpha-numeric order, the most common pairs are
\code{(Negative | Positive)}, \code{(0 | 1)}, \code{(FALSE | TRUE)}. Default : 2.}

\item{tidy}{Logical operator (TRUE/FALSE) to decide the type of return. TRUE
returns a data.frame, FALSE returns a list; Default : FALSE.}

\item{na.rm}{Logic argument to remove rows with missing values
(NA). Default is na.rm = TRUE.}
}
\value{
an object of class \code{numeric} within a \code{list} (if tidy = FALSE) or within a
\verb{data frame} (if tidy = TRUE).
}
\description{
\code{specificity} estimates the specificity (a.k.a. selectivity,
or true negative rate -TNR-)
for a nominal/categorical predicted-observed dataset.

\code{FPR} estimates the false positive rate (a.k.a fall-out or false alarm)
for a nominal/categorical predicted-observed dataset.
}
\details{
The specificity (or selectivity, or true negative rate-TNR-) is a non-normalized
coefficient that represents the ratio between the correctly negative predicted
cases (or true negative -TN- for binary cases) to the total number of actual
observations not belonging to a given class (actual negatives -N- for binary cases).

For binomial cases, \eqn{specificity  =  \frac{TN}{N} = \frac{TN}{TN+FP}}

The \code{specificity} metric is bounded between 0 and 1. The closer to 1 the better.
Values towards zero indicate low performance. For multinomial cases, it can be
either estimated for each particular class or at a global level.

The false positive rate (or false alarm, or fall-out) is the complement of the
specificity, representing the ratio between the number of false positives (FP)
to the actual number of negatives (N). The \code{FPR} formula is:

\eqn{FPR = 1 - specificity = 1 - TNR = \frac{FP}{N}}

The \code{FPR} is bounded between 0 and 1. The closer to 0 the better. Low performance
is indicated with FPR > 0.5.

For the formula and more details, see
\href{https://adriancorrendo.github.io/metrica/articles/available_metrics_classification.html}{online-documentation}
}
\examples{
\donttest{
set.seed(123)
# Two-class
binomial_case <- data.frame(labels = sample(c("True","False"), 100, 
replace = TRUE), predictions = sample(c("True","False"), 100, replace = TRUE))
# Multi-class
multinomial_case <- data.frame(labels = sample(c("Red","Blue", "Green"), 100, 
replace = TRUE), predictions = sample(c("Red","Blue", "Green"), 100, replace = TRUE)    )

# Get specificity and FPR estimates for two-class case
specificity(data = binomial_case, obs = labels, pred = predictions, tidy = TRUE)
FPR(data = binomial_case, obs = labels, pred = predictions, tidy = TRUE)

# Get specificity estimate for each class for the multi-class case
specificity(data = multinomial_case, obs = labels, pred = predictions, tidy = TRUE)

# Get specificity estimate for the multi-class case at a global level
specificity(data = multinomial_case, obs = labels, pred = predictions, tidy = TRUE)
}
}
\references{
Ting K.M. (2017)
Sensitivity and Specificity.
\emph{In: Sammut C., Webb G.I. (eds) Encyclopedia of Machine Learning and Data Mining.}
\emph{Springer, Boston, MA.} \doi{10.1007/978-0-387-30164-8_752}

Trevethan, R. (2017).
\emph{Sensitivity, Specificity, and Predictive Values: Foundations, Pliabilities, and Pitfalls}
_ in Research and Practice. Front. Public Health 5:307_ \doi{10.3389/fpubh.2017.00307}
}
