% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_likelihood_ratios.R
\name{likelihood_ratios}
\alias{likelihood_ratios}
\alias{posLr}
\alias{negLr}
\alias{dor}
\title{Likelihood Ratios (Classification)}
\usage{
posLr(
  data = NULL,
  obs,
  pred,
  pos_level = 2,
  atom = FALSE,
  tidy = FALSE,
  na.rm = TRUE
)

negLr(
  data = NULL,
  obs,
  pred,
  pos_level = 2,
  atom = FALSE,
  tidy = FALSE,
  na.rm = TRUE
)

dor(
  data = NULL,
  obs,
  pred,
  pos_level = 2,
  atom = FALSE,
  tidy = FALSE,
  na.rm = TRUE
)
}
\arguments{
\item{data}{(Optional) argument to call an existing data frame containing the data.}

\item{obs}{Vector with observed values (character | factor).}

\item{pred}{Vector with predicted values (character | factor).}

\item{pos_level}{Integer, for binary cases, indicating the order (1|2) of the level
corresponding to the positive. Generally, the positive level is the second (2)
since following an alpha-numeric order, the most common pairs are
\code{(Negative | Positive)}, \code{(0 | 1)}, \code{(FALSE | TRUE)}. Default : 2.}

\item{atom}{Logical operator (TRUE/FALSE) to decide if the estimate is made for
each class (atom = TRUE) or at a global level (atom = FALSE); Default : FALSE.
When dataset is "binomial" atom does not apply.}

\item{tidy}{Logical operator (TRUE/FALSE) to decide the type of return. TRUE
returns a data.frame, FALSE returns a list; Default : FALSE.}

\item{na.rm}{Logic argument to remove rows with missing values
(NA). Default is na.rm = TRUE.}
}
\value{
an object of class \code{numeric} within a \code{list} (if tidy = FALSE) or within a
\verb{data frame} (if tidy = TRUE).
}
\description{
It estimates the positive likelihood ratio \code{posLr},
negative likelihood ratio \code{negLr}, and diagnostic odds ratio \code{dor}
for a nominal/categorical predicted-observed dataset.
}
\details{
The likelihood ratios are metrics designed to assess the expectations of
classification tasks. They are highly related to recall (sensitivity or true positive rate)
and specificity (selectivity or true negative rate).

For a multiclass case, positive and negative results are class-wise. We can either
hit the actual class, or the actual non-class. For example, a classification
may have 3 potential results: cat, dog, or fish. Thus, when the actual value is dog,
the only true positive is dog, but we can obtain a true negative either by classifying
it as a cat or a fish. The posLr, negLr, and dor estimates are the mean across all classes.

The positive likelihood ratio (posLr) measures the odds of obtaining a positive
prediction in cases that are actual positives.

The negative likelihood ratio (negLr) relates the odds of obtaining a negative
prediction for actual non-negatives relative to the probability of actual negative
cases obtaining a negative prediction result.

Finally, the diagnostic odds ratio (dor) measures the effectiveness of classification.
It represents the odds of a positive prediction result in actual (observed) positive
cases with respect to the odds of a positive prediction for the actual negative cases.

The ratios are define as follows:

\eqn{posLr = \frac{recall}{1+specificity} = \frac{TPR}{FPR}}

\eqn{negLr = \frac{1-recall}{specificity} = \frac{FNR}{TNR}}

\eqn{dor = \frac{posLr}{negLr}}

For more details, see
\href{https://adriancorrendo.github.io/metrica/articles/available_metrics_classification.html}{online-documentation}
}
\examples{
\donttest{
set.seed(123)
# Two-class
binomial_case <- data.frame(labels = sample(c("True","False"), 100, replace = TRUE), 
predictions = sample(c("True","False"), 100, replace = TRUE))
# Multi-class
multinomial_case <- data.frame(labels = sample(c("Red","Blue", "Green"), 100, replace = TRUE),
predictions = sample(c("Red","Blue", "Green"), 100, replace = TRUE)    )

# Get posLr, negLr, and dor for a two-class case
posLr(data = binomial_case, obs = labels, pred = predictions, tidy = TRUE)
negLr(data = binomial_case, obs = labels, pred = predictions, tidy = TRUE)
dor(data = binomial_case, obs = labels, pred = predictions, tidy = TRUE)

}
}
\references{
GlasaJeroen, A.S., Lijmer, G., Prins, M.H., Bonsel, G.J., Bossuyta, P.M.M. (2009).
The diagnostic odds ratio: a single indicator of test performance.
\emph{Journal of Clinical Epidemiology 56(11): 1129-1135.} \doi{10.1016/S0895-4356(03)00177-X}
}
