% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cifreg.R
\name{cifreg}
\alias{cifreg}
\title{CIF regression}
\usage{
cifreg(formula, data = data, cause = 1, cens.code = 0,
  weights = NULL, offset = NULL, Gc = NULL, propodds = 1, ...)
}
\arguments{
\item{formula}{formula with 'Event' outcome}

\item{data}{data frame}

\item{cause}{of interest}

\item{cens.code}{code of censoring}

\item{weights}{weights for Cox score equations}

\item{offset}{offsets for cox model}

\item{Gc}{censoring weights for time argument, default is to calculate these with a Kaplan-Meier estimator}

\item{propodds}{1 is logistic model, NULL is fine-gray model}

\item{...}{Additional arguments to lower level funtions}
}
\description{
CIF logistic for propodds=1 default
CIF Fine-Gray (cloglog) regression for propodds=NULL
}
\examples{
## data with no ties
data(bmt,package="timereg")
bmt$time <- bmt$time+runif(nrow(bmt))*0.01
bmt$id <- 1:nrow(bmt)

## logistic link  OR interpretation
ll=cifreg(Event(time,cause)~tcell+platelet+age,data=bmt,cause=1)
bplot(ll)
nd <- data.frame(tcell=c(1,0),platelet=0,age=0)
pll <- predict(ll,nd)
plot(pll)

## Fine-Gray model
llfg=cifreg(Event(time,cause)~tcell+platelet+age,data=bmt,cause=1,propodds=NULL)
bplot(ll)
nd <- data.frame(tcell=c(1,0),platelet=0,age=0)
pll <- predict(ll,nd)
plot(pll)

}
\author{
Thomas Scheike
}
