% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmev_wrapper.R
\name{rparp}
\alias{rparp}
\title{Simulation from R-Pareto processes}
\usage{
rparp(n, shape = 1, riskf = c("sum", "site", "max"), siteindex = NULL, d,
  param, sigma, model = c("log", "neglog", "bilog", "negbilog", "hr", "br",
  "xstud", "smith", "schlather", "ct", "sdir", "dirmix"), weights, vario, loc,
  ...)
}
\arguments{
\item{n}{number of observations}

\item{shape}{shape index of Pareto variable}

\item{riskf}{string indicating risk functional.}

\item{siteindex}{integer between 1 and d specifying the index of the site or variable}

\item{d}{dimension of sample}

\item{param}{parameter vector for the logistic, bilogistic, negative bilogistic and extremal Dirichlet (Coles and Tawn) model.
Parameter matrix for the Dirichlet mixture. Degree of freedoms for extremal student model. See \bold{Details}.}

\item{sigma}{covariance matrix for Brown-Resnick and extremal Student-t distributions. Symmetric matrix of squared  coefficients \eqn{\lambda^2} for the Husler-Reiss model, with zero diagonal elements.}

\item{model}{for multivariate extreme value distributions, users can choose between 1-parameter logistic and negative logistic, asymmetric logistic and negative logistic, bilogistic, Husler-Reiss, extremal Dirichlet model (Coles and Tawn) or the Dirichlet mixture. Spatial models include
the Brown-Resnick, Smith, Schlather and extremal Student max-stable processes.}

\item{weights}{vector of length \code{m} for the \code{m} mixture components. Must sum to one}

\item{vario}{variogram function whose first argument must be distance. Used only if provided in conjonction with \code{loc} and if \code{sigma} is missing}

\item{loc}{\code{d} by \code{k} matrix of location, used as input in the variogram \code{vario} or as parameter for the Smith model. If \code{grid} is \code{TRUE}, unique entries should be supplied.}

\item{...}{additional arguments for the \code{vario} function}
}
\description{
Simulation from R-Pareto processes
}
\details{
For \code{riskf=max} and \code{riskf=min}, the procedure uses rejection sampling based on Pareto variates
sampled from \code{sum} and may be slow if \code{d} is large.
}
\examples{
rparp(n=10, riskf = "site", siteindex=2, d=3, param=2.5, model="log")
rparp(n=10, riskf = "min", d=3, param=2.5, model="neglog")
rparp(n=10, riskf = "max", d=4, param=c(0.2,0.1,0.9,0.5), model="bilog")
rparp(n=10, riskf = "sum", d=3, param=c(0.8,1.2,0.6, -0.5), model="sdir")
vario <- function(x, scale=0.5, alpha=0.8){ scale*x^alpha }
grid.loc <- as.matrix(expand.grid(runif(4), runif(4)))
rparp(n=10, riskf = "max", vario=vario,loc=grid.loc, model="br")
}
