% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivar.R
\name{lambdadep}
\alias{lambdadep}
\title{Estimation of the bivariate lambda function of Wadsworth and Tawn (2013)}
\usage{
lambdadep(dat, qu = 0.95, method = c("hill", "mle", "bayes"), plot = TRUE)
}
\arguments{
\item{dat}{an \eqn{n} by \eqn{2} matrix of multivariate observations}

\item{qu}{quantile level on uniform scale at which to threshold data. Default to 0.95}

\item{method}{string indicating the estimation method}

\item{plot}{logical indicating whether to return the graph of \code{lambda}


The confidence intervals are based on normal quantiles. The standard errors for the \code{hill}
are based on the asymptotic covariance and that of the \code{mle} derived using the delta-method.
Bayesian posterior predictive interval estimates are obtained using ratio-of-uniform sampling with flat priors:
the shape parameters are constrained to lie within the triangle, as are frequentist point estimates
which are adjusted post-inference.}
}
\value{
a plot of the lambda function if \code{plot=TRUE}, plus an invisible list with components
\itemize{
\item \code{w} the sequence of angles in (0,1) at which the \code{lambda} values are evaluated
\item \code{lambda} point estimates of lambda
\item \code{lower.confint} 95% confidence interval for lambda (lower bound)
\item \code{upper.confint} 95% confidence interval for lambda (upper bound)
}
}
\description{
Estimation of the bivariate lambda function of Wadsworth and Tawn (2013)
}
\examples{
set.seed(12)
dat <- evd::rbvevd(n=1000, dep = 0.1)
lambdadep(dat, method = 'hill')
\dontrun{
lambdadep(dat, method = 'bayes')
lambdadep(dat, method = 'mle')
dat <- matrix(runif(n = 2000), ncol = 2)
lambdadep(dat, method = 'hill')
}
}
