% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threshold.R
\name{tstab.gpd}
\alias{tstab.gpd}
\title{Parameter stability plots for peaks-over-threshold}
\usage{
tstab.gpd(
  dat,
  thresh,
  method = c("wald", "profile", "post"),
  level = 0.95,
  plot = TRUE,
  ...
)
}
\arguments{
\item{dat}{a vector of observations}

\item{thresh}{a vector of candidate thresholds at which to compute the estimates.}

\item{method}{string indicating the method for computing confidence or credible intervals.
Must be one of \code{"wald"}, \code{"profile"} or \code{"post"}.}

\item{level}{confidence level of the intervals. Default to 0.95.}

\item{plot}{logical; should parameter stability plots be displayed? Default to \code{TRUE}.}

\item{...}{additional arguments passed to \code{plot}.}
}
\value{
a list with components
\itemize{
\item{\code{threshold}:} vector of numerical threshold values.
\item{\code{mle}:} matrix of modified scale and shape maximum likelihood estimates.
\item{\code{lower}:} matrix of lower bounds for the confidence or credible intervals.
\item{\code{upper}:} matrix of lower bounds for the confidence or credible intervals.
\item{\code{method}:} method for the confidence or coverage intervals.
}

plots of the modified scale and shape parameters, with pointwise confidence/credible intervals
and an invisible data frame containing the threshold \code{thresh} and the modified scale and shape parameters.
}
\description{
This function computes the maximum likelihood estimate
at each provided threshold and plots the estimates (pointwise),
along with 95% confidence/credible intervals obtained using Wald or profile confidence intervals,
or else from 1000 independent draws from the posterior distribution under
vague independent normal prior on the log-scale and shape.
The latter two methods better reflect the asymmetry of the estimates than the Wald confidence intervals.
}
\examples{
dat <- abs(rnorm(10000))
u <- qnorm(seq(0.9,0.99, by= 0.01))
tstab.gpd(dat = dat, thresh = u)
\dontrun{
tstab.gpd(dat = dat, thresh = u, method = "profile")
tstab.gpd(dat = dat, thresh = u, method = "post")
}
}
\seealso{
\code{\link[ismev]{gpd.fitrange}}
}
\author{
Leo Belzile
}
