% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specdens.R
\name{emplik}
\alias{emplik}
\title{Self-concordant empirical likelihood for a vector mean}
\usage{
emplik(dat, mu = rep(0, ncol(dat)), lam = rep(0, ncol(dat)),
  eps = 1/nrow(dat), M = 1e+30, thresh = 1e-30, itermax = 100)
}
\arguments{
\item{dat}{\code{n} by \code{d} matrix of \code{d}-variate observations}

\item{mu}{\code{d} vector of hypothesized mean of \code{dat}}

\item{lam}{starting values for Lagrange multiplier vector, default to zero vector}

\item{eps}{lower cutoff for \eqn{-\log}{-log}, with default \code{1/nrow(dat)}}

\item{M}{upper cutoff for \eqn{-\log}{-log}.}

\item{thresh}{convergence threshold for log likelihood (default of \code{1e-30} is agressive)}

\item{itermax}{upper bound on number of Newton steps.}
}
\value{
a list with components
#' \itemize{
 \item \code{logelr} log empirical likelihood ratio.
 \item \code{lam} Lagrange multiplier (vector of length \code{d}).
 \item \code{wts} \code{n} vector of observation weights (probabilities).
 \item \code{conv} boolean indicating convergence.
 \item \code{niter} number of iteration until convergence.
 \item \code{ndec} Newton decrement.
 \item \code{gradnorm} norm of gradient of log empirical likelihood.
}
}
\description{
Self-concordant empirical likelihood for a vector mean
}
\author{
Art Owen, \code{C++} port by Leo Belzile
}
\references{
Owen, A.B. (2013). Self-concordance for empirical likelihood, \emph{Canadian Journal of Statistics}, \bold{41}(3), 387--397.
}

