% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tem.R
\name{gev.tem}
\alias{gev.tem}
\title{Tangent exponential model approximation for the GEV distribution}
\usage{
gev.tem(param = c("loc", "scale", "shape", "VaR"), dat, psi = NULL,
  p = NULL, n.psi = 50, plot = TRUE)
}
\arguments{
\item{param}{parameter over which to profile}

\item{dat}{sample vector for the GEV distribution}

\item{psi}{scalar or ordered vector of values for the interest parameter. If \code{NULL} (default), a grid of values centered at the MLE is selected}

\item{p}{probability associated with the (1-p)th quantile for return levels if \code{param="VaR"}.}

\item{n.psi}{number of values of \code{psi} at which the likelihood is computed, if \code{psi} is not supplied (\code{NULL}). Odd values are more prone to give rise to numerical instabilities near the MLE}

\item{plot}{logical indiating whether \code{plot.fr} should be called upon exit}
}
\value{
an object of class \code{fr} (see \code{\link[hoa]{tem}}) with elements
\itemize{
\item{\code{normal}: }{maximum likelihood estimate and standard error of the interest parameter \eqn{psi}}
\item{\code{par.hat}: }{maximum likelihood estimates}
\item{\code{par.hat.se}: }{standard errors of maximum likelihood estimates}
\item{\code{th.rest}: }{estimated maximum profile likelihood at (\eqn{psi},\eqn{\hat{\lambda}})}
\item{\code{r}: }{values of likelihood root corresponding to \eqn{\psi}}
\item{\code{psi}: }{vector of interest parameter}
\item{\code{q}: }{vector of likelihood modifications}
\item{\code{rstar}: }{modified likelihood root vector}
\item{\code{param}: }{parameter}
}
}
\description{
The function \code{gev.tem} provides a tangent exponential model (TEM) approximation
for higher order likelihood inference for a scalar parameter for the generalized extreme value distribution.
Options include location scale and shape parameters as well as value-at-risk (or return levels).
The function attempts to find good values for \code{psi} that will
cover the range of options, but the fail may fit and return an error.
}
\author{
Leo Belzile, from code by A. Davison from the \code{hoa} package
}

