% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extgp.R
\name{fit.egp}
\alias{fit.egp}
\title{Parameter stability plot and maximum likelihood routine for extended GP models}
\usage{
fit.egp(
  xdat,
  thresh = 0,
  model = c("pt-beta", "pt-gamma", "pt-power", "gj-tnorm", "gj-beta", "exptilt",
    "logist"),
  start = NULL,
  method = c("Nelder", "nlminb", "BFGS"),
  fpar = NULL,
  show = FALSE,
  ...
)
}
\arguments{
\item{xdat}{vector of observations, greater than the threshold}

\item{thresh}{threshold value}

\item{model}{a string indicating which extended family to fit}

\item{start}{optional named list of initial values, with \eqn{\kappa}{\kappa}, \eqn{sigma}{\sigma} or \eqn{xi}{\xi}.}

\item{method}{the method to be used. See \bold{Details}. Can be abbreviated.}

\item{fpar}{a named list with fixed parameters, either \code{scale} or \code{shape}}

\item{show}{logical; if \code{TRUE}, print the results of the optimization}

\item{...}{additional parameters, for backward compatibility purposes}
}
\value{
\code{fit.egp} outputs the list returned by \link[stats]{optim}, which contains the parameter values, the hessian and in addition the standard errors

\code{tstab.egp} returns a plot(s) of the parameters fit over the range of provided thresholds, with pointwise normal confidence intervals; the function also returns an invisible list containing notably the matrix of point estimates (\code{par}) and standard errors (\code{se}).
}
\description{
The function \code{tstab.egp} provides classical threshold stability plot for (\eqn{\kappa}, \eqn{\sigma}, \eqn{\xi}).
The fitted parameter values are displayed with pointwise normal 95\% confidence intervals.
The function returns an invisible list with parameter estimates and standard errors, and p-values for the Wald test that \eqn{\kappa=1}.
 The plot is for the modified scale (as in the generalised Pareto model) and as such it is possible that the modified scale be negative.
\code{tstab.egp} can also be used to fit the model to multiple thresholds.
}
\details{
\code{fit.egp} is a numerical optimization routine to fit the extended generalised Pareto models of Papastathopoulos and Tawn (2013),
using maximum likelihood estimation.
}
\examples{
xdat <- mev::rgp(
  n = 100,
  loc = 0,
  scale = 1,
  shape = 0.5)
fitted <- fit.egp(
  xdat = xdat,
  thresh = 1,
  model = "pt-gamma",
  show = TRUE)
thresh <- mev::qgp(seq(0.1, 0.5, by = 0.05), 0, 1, 0.5)
tstab.egp(
   xdat = xdat,
   thresh = thresh,
   model = "pt-gamma")
xdat <- regp(
  n = 100,
  scale = 1,
  shape = 0.1,
  kappa = 0.5,
  model = "pt-power"
)
fit.egp(
 xdat = xdat,
 model = "pt-power",
 show = TRUE,
 fpar = list(kappa = 1),
 method = "Nelder"
)
}
\references{
Papastathopoulos, I. and J. Tawn (2013). Extended generalised Pareto models for tail estimation, \emph{Journal of Statistical Planning and Inference} \bold{143}(3), 131--143.
}
\author{
Leo Belzile
}
