% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals_gamViz.R
\name{residuals.gamViz}
\alias{residuals.gamViz}
\title{Generalized Additive Model residuals}
\usage{
\method{residuals}{gamViz}(object, type = "deviance", ...)
}
\arguments{
\item{object}{an object of class \code{gamViz}, the output of a \code{getViz()} call.}

\item{type}{the type of residuals wanted. If should be one of "deviance", "pearson", "scaled.pearson",
"working", "response", "tunif" or "tnormal". Not all are available for each family.}

\item{...}{further arguments passed to \link[mgcv:residuals.gam]{mgcv::residuals.gam}.}
}
\description{
Extension of \code{mgcv::residuals.gam}. Returns residuals for a fitted GAM model object.
Pearson, deviance, working and response residuals are available as in the method from
\code{mgcv}, but this version also provides residual types "tunif" and "tnormal". The former are
obtained using the cdf of the response distribution (if available). The latter are obtained
by further transforming the uniform residuals using the quantile function (i.e. the inverse
cdf) of a standard normal variable.
}
\seealso{
See also \link[mgcv:residuals.gam]{mgcv::residuals.gam} for details.
}
