\name{smooth.construct.re.smooth.spec}
\alias{smooth.construct.re.smooth.spec}
\alias{Predict.matrix.random.effect}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Simple random effects in GAMs}

\description{\code{\link{gam}} can deal with simple independent random effects, by exploiting the link 
between smooths and random effects to treat random effects as smooths. \code{s(x,bs="re")} implements 
this. Such terms can can have any number of predictors, which can be any mixture of numeric or factor 
variables. The terms produce a parametric interaction of the predictors, and penalize the corresponding 
coefficients with a multiple of the identity matrix, corresponding to an assumption of i.i.d. normality.
See details.

}

\usage{
\method{smooth.construct}{re.smooth.spec}(object, data, knots)
\method{Predict.matrix}{random.effect}(object, data)
}

\arguments{ 
\item{object}{For the \code{smooth.construct} method a smooth specification object, 
usually generated by a term \code{s(x,...,bs="re",)}. For the \code{predict.Matrix} method 
an object of class \code{"random.effect"} produced by the \code{smooth.construct} method.}

\item{data}{a list containing just the data (including any \code{by} variable) required by this term, 
            with names corresponding to \code{object$term} (and \code{object$by}). The \code{by} variable 
            is the last element.} 

\item{knots}{generically a list containing any knots supplied for basis setup --- unused at present.}

}

\value{ An object of class \code{"random.effect"} or a matrix mapping the coefficients of the random effect to the random effects themselves.
}

\details{Exactly how the random effects are implemented is best seen by example. Consider the model 
term \code{s(x,z,bs="re")}. This will result in the model matrix component corresponding to \code{~x:z-1} 
being added to the model matrix for the whole model. The coefficients associated with the model matrix 
component are assumed i.i.d. normal, with unknown variance (to be estimated). This assumption is 
equivalent to an identity penalty matrix (i.e. a ridge penalty) on the coefficients. Because such a 
penalty is full rank, random effects terms do not require centering constraints. 

If the nature of the random effect specification is not clear, consider a couple more examples: 
\code{s(x,bs="re")} results in \code{model.matrix(~x-1)} being appended to the overall model matrix, 
while  \code{s(x,v,w,bs="re")} would result in  \code{model.matrix(~x:v:w-1)} being appended to the model 
matrix. In both cases the corresponding model coefficients are assumed i.i.d. normal, and are hence 
subject to ridge penalties.
  
Note that smooth \code{id}s are not supported for random effect terms. Unlike most smooth terms, side 
conditions are never applied to random effect terms in the event of nesting (since they are identifiable 
without side conditions).

Random effects implemented in this way do not exploit the sparse structure of many random effects, and 
may therefore be relatively inefficient for models with large numbers of random effects, when \code{gamm4}
or \code{\link{gamm}} may be better alternatives. Note also that \code{\link{gam}} will not support 
models with more coefficients than data. 

}

\references{
Wood, S.N. (2008) Fast stable direct fitting and smoothness
 selection for generalized additive models. Journal of the Royal
 Statistical Society (B) 70(3):495-518
}

\author{ Simon N. Wood \email{simon.wood@r-project.org}}

\seealso{\code{\link{gam.vcomp}}, \code{\link{gamm}}}

\examples{
## see ?gam.vcomp
}
\keyword{models} \keyword{regression}%-- one or more ..


