% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeOverlap_function.R
\name{makeOverlap}
\alias{makeOverlap}
\title{Returns SNPs that appear in two user-defined groups for a given gene}
\usage{
makeOverlap(mgl, snpsA = c("transEqtls", "cisEqtls", "sqtlSeek",
  "sqtlAltrans", "pqtl", "dnase", "gwasCatalog", "grasp"),
  snpsB = c("transEqtls", "cisEqtls", "sqtlSeek", "sqtlAltrans", "pqtl",
  "dnase", "gwasCatalog", "grasp"), saveFile = FALSE)
}
\arguments{
\item{mgl}{List; see \code{\link{buildFromNames}}, \code{\link{buildFromRegion}}, or \code{\link{buildFromEnsgs}}}

\item{snpsA}{A character vector indicating which elements of mgl should be used to define group A - any combination of 'eqtl', 'sqtlSeek', 'sqtlAltrans', 'pqtl', 'dnase', 'gwasCatalog', 'grasp'}

\item{snpsB}{A character vector indicating which elements of mgl should be used to define group B - any combination of 'eqtl', 'sqtlSeek', 'sqtlAltrans', 'pqtl', 'dnase', 'gwasCatalog', 'grasp'}

\item{saveFile}{A logical flag indicating whether a csv file ('Overlap[groups].csv') should be saved in the current directory}
}
\description{
\code{makeSummary} returns a list with the first element (named overlap) being a list corresponding to the number of genes in mgl with each element as a vector of SNPs that overlap between the two user-defined groups.  The second two elements (named snpsA and snpsB)are the user-defined groups
}
\details{
Provides a character vector of SNPs for each gene that appear in two different groups as defined by the user.  These groups can be built from any element in mgl containing SNP information: eqtl, sqtlSeek, sqtlAltrans, pqtl, dnase, gwasCatalog, grasp.  Can be used to determine those SNPs that appear as both regulatory variants and trait associated variants, for example.
}
\examples{
exMgl() -> myMgl
makeOverlap(myMgl, snpsA = c('cisEqtls'), snpsB = c('gwasCatalog'), saveFile = TRUE) -> myOverlap

}
\seealso{
Other output: \code{\link{makeAeiPlot}},
  \code{\link{makeCoXpGene}},
  \code{\link{makeCoXpTranscript}},
  \code{\link{makeDnaseSig}}, \code{\link{makeGoSearch}},
  \code{\link{makeGo}}, \code{\link{makeMultiEqtl}},
  \code{\link{makeOverlapTable}},
  \code{\link{makePhenotypeSearch}},
  \code{\link{makePhenotypes}},
  \code{\link{makeSnpSearch}}, \code{\link{makeSnps}},
  \code{\link{makeSummary}}
}

