% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgss_main.R
\name{PCG_smooth}
\alias{PCG_smooth}
\title{High-dimensional spline smoothing using a matrix-free PCG-method.}
\usage{
PCG_smooth(
  m,
  q,
  lambda,
  X,
  y,
  pen_type = "curve",
  l = NULL,
  alpha_start = NULL,
  K_max = NULL,
  tolerance = 1e-06,
  print_error = TRUE
)
}
\arguments{
\item{m}{Vector of non-negative integers. Each entry gives the number of inner knots for the respective covariate.}

\item{q}{Vector of positive integers. Each entry gives the spline degree for the respective covariate.}

\item{lambda}{Positive number as weight for the penalty term.}

\item{X}{Matrix containing the covariates as columns and the units as rows.}

\item{y}{Vector of length \code{nrow(X)} as the variable of interest.}

\item{pen_type}{Utilized penalization method. Either \code{"curve"} for the curvature penalty or \code{"diff"} for the difference penalty. Defaults to \code{"curve"}.}

\item{l}{Positive integer vector of length \code{P} indicating for the penalty degree. Only required if \code{pen_type = "diff"}.}

\item{alpha_start}{Vector of length \code{prod(m+q+1)} as starting value for the PCG-method. Defaults to zero.}

\item{K_max}{Positive integer as upper bound for the number of PCG-iterations. Defaults to \code{prod(m+q+1)}.}

\item{tolerance}{Positive number as error tolerance for the stopping criterion of the PCG-method. Defaults to \code{1e-6}.}

\item{print_error}{Logical, indicating if the iteration error should be printed or not.}
}
\value{
Returns a list containing the input \code{m}, \code{q}, and \code{Omega}. Further gives the fitted spline coefficients \code{alpha}, the fitted values \code{fitted_values}, the residuals \code{residuals}, the root mean squared error \code{rmse} and the R-squared value \code{R_squared}.
}
\description{
Fits a smooth spline to a set of given observations using penalized splines with curvature or difference penalty and multiple covariates. The underlying linear system is solved with a matrix-free preconditioned conjugated gradient (PCG) method using a diagonal preconditioner.
}
\examples{
data <- generate_test_data(100, 2)
X <- data$X_train
y <- data$y_train
PCG_smooth(m = c(7,7), q = c(3,3), lambda = 0.1, X = X, y = y)

}
