\name{rsq}
\alias{rsq}
\title{R squared and pseudo R squared}
\description{
  This function computes the R squared for multiple hurdle models. The
  measure is a pseudo coefficient of determination or may be based on
  the likelihood.
}
\usage{
rsq(object, type = c("coefdet", "lratio"),
            adj = FALSE, r2pos = c("rss", "ess", "cor"))
}
\arguments{
  \item{object}{an object of class \code{"mhurdle"},}
  \item{type}{one of \code{"coefdet"} or \code{"lratio"} to select a
    pseudo coefficient of correlation or a Mc Fadden like measure based
    on the likelihood function,}
  \item{adj}{if \code{TRUE} a correction for the degrees of freedom is
    performed,}
  \item{r2pos}{only for pseudo coefficient of determination, should the
    positive part of the R squared be computed using the residual sum of
    squares (\code{"rss"}), the explained sum of squares (\code{"ess"})
    or the coefficient of correlation between the fitted values and the
    response (\code{cor}).
    }
}
\value{
  a numerical value
}
%\details{
%}
% \seealso{
% }

\references{
  
 McFadden D (1974). The Measurement of Urban Travel Demand. Journal of
 Public Economics, 3, 303-328.
 
}
\examples{
data("Comics", package = "mhurdle")
Comics$incu <- with(Comics, income / cu)
Comics$incum <- with(Comics, incu / mean(incu))
model3 <- mhurdle(comics ~ 0 | log(incum) + I(log(incum)^2) +
                  I(log(incum)^3) + age  + gender + educ +
                  size| 0, Comics, dist = "n", method = 'bfgs')
rsq(model3, type = "lratio")
rsq(model3, type = "coefdet", adj = TRUE, r2pos = "rss")

}
\keyword{htest}
