% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_impute.R
\name{multi.impute}
\alias{multi.impute}
\title{Function to impute quantitative datasets}
\usage{
multi.impute(data, conditions, nb.imp = NULL, method, parallel = FALSE)
}
\arguments{
\item{data}{Dataset to impute.}

\item{conditions}{Vector with the condition values.}

\item{nb.imp}{Number of imputed dataset to create.}

\item{method}{Imputation method, choose from \code{c("pmm", "midastouch", 
"sample", "cart", "rf", "mean", "norm", "norm.nob", "norm.boot", 
"norm.predict")}.}

\item{parallel}{Use parallel computing?}
}
\value{
a numeric array of dim c(dim(data),nb.imp).
}
\description{
This function creates an array made of slices of imputed dataset. Imputation methods can be chosen from \code{c("pmm", "midastouch", 
"sample", "cart", "rf", "mean", "norm", "norm.nob", "norm.boot", 
"norm.predict")}.
}
\examples{
library(mi4p)
data(datasim)
multi.impute(data = datasim[,-1], conditions = attr(datasim,"metadata")$Condition, method = "MLE")
}
\references{
M. Chion, Ch. Carapito and F. Bertrand (2021). \emph{Accounting for multiple imputation-induced variability for differential analysis in mass spectrometry-based label-free quantitative proteomics}. arxiv:2108.07086. \url{https://arxiv.org/abs/2108.07086}.
}
