% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/milags_functions.R
\name{fit_exp_lag_to_curve}
\alias{fit_exp_lag_to_curve}
\title{fit_exp_lag_to_curve}
\usage{
fit_exp_lag_to_curve(data, n0, tangent_method = "to.point", curve_points = 3)
}
\arguments{
\item{data}{a data frame with two required columns names: "time" and "biomass",
This is data from one growth curve only, one (mean) observation per time}

\item{n0}{the initial biomass (a tangent line crossing N0 line will determine the lag)}

\item{tangent_method}{"local.regression" (if the tangent is fitted to a number of points around the maximal growth rate)
or "to.point" (if the tangent is fitted only to the point where the growth rate is maximal); defaults to "to.point"}

\item{curve_points}{if tangent_method = "local.regression" then curve_points is the number of points the line is fitted to;
defaults to 3 i.e. the point with the maximal uptake rate one point before and one point after}
}
\value{
line_slope: slope of the tangent line,
line_intercept: intercept of the tangent line,
lag: lag,
tangent_points: i..e a data frame of all points selected for fitting the line
}
\description{
Fits the lag to one growth curve based on the basic tangent method
}
