% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biomarker_score.R
\name{plot_score_biomarker}
\alias{plot_score_biomarker}
\title{Plot frequency of biomarker scores in abstracts}
\usage{
plot_score_biomarker(
  df,
  keywords = biomarker_keywords,
  case = FALSE,
  bins = NULL,
  colour = "steelblue3",
  col.abstract = Abstract,
  col.pmid = PMID,
  title = NULL
)
}
\arguments{
\item{df}{Data frame containing abstracts.}

\item{keywords}{Character vector. Vector containing keywords. The biomarker
score is calculated based on these keywords. How much weight a keyword
in \code{keywords} carries is determined how often it is present in \code{keywords},
e.g. if a keyword is mentioned twice in \code{keywords} and it is mentioned only once in
an abstract, it adds 2 points to the score.}

\item{case}{Boolean. If \code{case = TRUE}, terms contained in \code{keywords} are case
sensitive. If \code{case = FALSE}, terms contained in \code{keywords} are case insensitive.}

\item{bins}{Integer. Specifies how many bins are used to plot
the distribution. If \code{bins = NULL}, bins are calculated over the whole
range of scores, with one bin per score.}

\item{colour}{String. Colour of histogram.}

\item{col.abstract}{Symbol. Column containing abstracts.}

\item{col.pmid}{Symbol. Column containing PubMed-IDs.}

\item{title}{String. Plot title.}
}
\value{
Histogram displaying the distribution of biomarker scores in abstracts.
}
\description{
Plot frequency of biomarker scores in abstracts.
}
\details{
Plots a frequency distribution of biomarker scores in abstracts of a
data frame. The biomarker score is influenced by the choice of
terms in \code{keywords}.
Plotting the distribution can help deciding if the
terms are well-chosen, or in choosing the right threshold to decide
which abstracts are considered to contain use of miRNAs as biomarker.
}
\seealso{
\code{\link[=calculate_score_biomarker]{calculate_score_biomarker()}}

Other score functions: 
\code{\link{assign_topic}()},
\code{\link{calculate_score_animals}()},
\code{\link{calculate_score_biomarker}()},
\code{\link{calculate_score_patients}()},
\code{\link{calculate_score_topic}()},
\code{\link{plot_score_animals}()},
\code{\link{plot_score_patients}()},
\code{\link{plot_score_topic}()}
}
\concept{score functions}
