% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df_operations_combine_addtopic_subsetmir.R
\name{subset_df}
\alias{subset_df}
\title{Subset data frame for a term}
\usage{
subset_df(df, col.filter, filter_for = "Yes")
}
\arguments{
\item{df}{Data frame to subset.}

\item{col.filter}{String. Name of column to filter.}

\item{filter_for}{String. Term to filter for.}
}
\value{
Data frame, subset for rows where \code{filter_for} was
present in \code{col.filter}.
}
\description{
Subset data frame for a term in a specified column.
}
\details{
Subset data frame for a term in a specified column.
\code{subset_df()}
filters a data frame for a certain term in a specified column. All
rows containing the term in the specified column are kept, while the other
rows are silently dropped.
Here, \code{col.filter} is a string rather than
a symbol to facilitate filtering in columns that carry special characters
such as '-' in their name.
}
\seealso{
\code{\link[=indicate_term]{indicate_term()}}, \code{\link[=indicate_mir]{indicate_mir()}}, \code{\link[=extract_snp]{extract_snp()}}

Other subset functions: 
\code{\link{subset_mir_threshold}()},
\code{\link{subset_mir}()},
\code{\link{subset_research}()},
\code{\link{subset_review}()},
\code{\link{subset_snp}()},
\code{\link{subset_year}()}
}
\concept{subset functions}
