% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mica.study.populations.R
\name{mica.study.populations}
\alias{mica.study.populations}
\title{Get the study populations}
\usage{
mica.study.populations(
  mica,
  query = "study()",
  select = list("populations.name", "populations.description", "populations.model"),
  sort = list("id"),
  from = 0,
  limit = 100,
  locale = "en",
  df = TRUE
)
}
\arguments{
\item{mica}{A Mica object}

\item{query}{The search query}

\item{select}{The fields to be extracted}

\item{sort}{The fields to sort by}

\item{from}{From item}

\item{limit}{Max number of items. Note that this limit applies to the studies that are fetched, the resulting count of populations will be higher.}

\item{locale}{The language for labels (default is "en")}

\item{df}{Return a data.frame (default is TRUE)}
}
\description{
Get the study populations. Note that the populations are not fetched directly, they are extracted from study search results.
}
\examples{
\dontrun{
m <- mica.login("https://mica-demo.obiba.org")
mica.study.populations(m, query="study(in(Mica_study.methods-design,cohort_study))")
mica.logout(m)
}
}
\seealso{
Other studies functions: 
\code{\link{mica.studies}()},
\code{\link{mica.study.dces}()}
}
\concept{studies functions}
