% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool_risk_ratio.R
\name{pool_risk_ratio}
\alias{pool_risk_ratio}
\title{Calculates the pooled risk ratio (RR) and related confidence interval.}
\usage{
pool_risk_ratio(object, conf.level = 0.95, dfcom = NULL)
}
\arguments{
\item{object}{An object of class 'mistats' ('Multiply Imputed
Statistical Analysis').}

\item{conf.level}{Confidence level of the confidence intervals.}

\item{dfcom}{Complete data degrees of freedom. Default
number is taken from function \code{risk_ratio}}
}
\value{
The pooled RR and confidence intervals.
}
\description{
\code{pool_risk_ratio} Calculates the pooled risk ratio and
confidence interval.
}
\examples{

library(magrittr)
lbpmilr \%>\%
 df2milist(impvar="Impnr") \%>\%
   with(expr=risk_ratio(Chronic ~ Radiation)) \%>\%
     pool_risk_ratio()

# Same as
imp_dat <- df2milist(lbpmilr, impvar="Impnr")
ra <- with(imp_dat, expr=risk_ratio(Chronic ~ Radiation))
res <- pool_risk_ratio(ra)

}
\seealso{
\code{\link{with.milist}}, \code{\link{risk_ratio}}
}
\author{
Martijn Heymans, 2021
}
