% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_evolution.R
\name{st_evolution}
\alias{st_evolution}
\title{Generate boxplots of the stability evolution throughout sampling times by groups}
\usage{
st_evolution(data, groups = NULL, points = TRUE, linetype = 2)
}
\arguments{
\item{data}{input data frame resulting from \code{\link[=st_previz]{st_previz()}}.}

\item{groups}{vector with the same length as the number of rows in the \code{\link[=st_previz]{st_previz()}} output.}

\item{points}{logical; FALSE to only visualize boxplots or TRUE to also add individual points.}

\item{linetype}{numeric; type of line to connect the median value of paired times; 0 to avoid the line.}
}
\value{
A plot with as many boxes as paired times by group in the form of a "ggplot" object.
}
\description{
Generate boxplots of the stability evolution throughout sampling times by groups
}
\examples{
t1_t2 <- paired_times(data = clr[,1:25], first = "_1",
                      second = "_25", common = "_0_")
t2_t3 <- paired_times(data = clr[,1:25], first = "_25",
                      second = "_26", common = "_0_")
klist_t1_t2 <- iterative_clustering(data = t1_t2, parallel = FALSE)
klist_t2_t3 <- iterative_clustering(data = t2_t3, parallel = FALSE)
result_t1_t2 <- stabilitas(klist_t1_t2, common = "_0_")
result_t2_t3 <- stabilitas(klist_t2_t3, common = "_0_")
results <- st_previz(results = list(result_t1_t2, result_t2_t3),
                     times = c("t1_t2", "t2_t3"))
metadata <- data.frame(Sample = rownames(clr),
                       age = c(rep("youth", 65), rep("old", 131-65)))
group <- metadata_groups(metadata = metadata, samples = metadata$Sample,
                         individuals = results$individual, col_number = 2)
st_evolution(results, groups = group, points = TRUE, linetype = 0)
}
