% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/microtable.R
\name{microtable}
\alias{microtable}
\title{Create \code{microtable} object to store and manage all the basic files.}
\format{
microtable.
}
\description{
This class is a wrapper for a series of operations on the input files and basic manipulations,
including microtable object creation, data trimming, data filtering, rarefaction based on Paul et al. (2013) <doi:10.1371/journal.pone.0061217>, taxonomic abundance calculation, 
alpha and beta diversity calculation based on the An et al. (2019) <doi:10.1016/j.geoderma.2018.09.035> and 
Lozupone et al. (2005) <doi:10.1128/AEM.71.12.8228-8235.2005> and other basic operations.\cr
\cr
Online tutorial: \href{https://chiliubio.github.io/microeco_tutorial/}{https://chiliubio.github.io/microeco_tutorial/} \cr
Download tutorial: \href{https://github.com/ChiLiubio/microeco_tutorial/releases}{https://github.com/ChiLiubio/microeco_tutorial/releases}
}
\examples{

## ------------------------------------------------
## Method `microtable$new`
## ------------------------------------------------

data(otu_table_16S)
data(taxonomy_table_16S)
data(sample_info_16S)
data(phylo_tree_16S)
m1 <- microtable$new(otu_table = otu_table_16S)
m1 <- microtable$new(sample_table = sample_info_16S, otu_table = otu_table_16S, 
  tax_table = taxonomy_table_16S, phylo_tree = phylo_tree_16S)
# trim the files in the dataset
m1$tidy_dataset()

## ------------------------------------------------
## Method `microtable$filter_pollution`
## ------------------------------------------------

m1$filter_pollution(taxa = c("mitochondria", "chloroplast"))

## ------------------------------------------------
## Method `microtable$filter_taxa`
## ------------------------------------------------

\donttest{
d1 <- clone(m1)
d1$filter_taxa(rel_abund = 0.0001, freq = 0.2)
}

## ------------------------------------------------
## Method `microtable$rarefy_samples`
## ------------------------------------------------

\donttest{
m1$rarefy_samples(sample.size = min(m1$sample_sums()))
}

## ------------------------------------------------
## Method `microtable$tidy_dataset`
## ------------------------------------------------

m1$tidy_dataset(main_data = TRUE)

## ------------------------------------------------
## Method `microtable$add_rownames2taxonomy`
## ------------------------------------------------

\donttest{
m1$add_rownames2taxonomy()
}

## ------------------------------------------------
## Method `microtable$sample_sums`
## ------------------------------------------------

\donttest{
m1$sample_sums()
}

## ------------------------------------------------
## Method `microtable$taxa_sums`
## ------------------------------------------------

\donttest{
m1$taxa_sums()
}

## ------------------------------------------------
## Method `microtable$sample_names`
## ------------------------------------------------

\donttest{
m1$sample_names()
}

## ------------------------------------------------
## Method `microtable$taxa_names`
## ------------------------------------------------

\donttest{
m1$taxa_names()
}

## ------------------------------------------------
## Method `microtable$rename_taxa`
## ------------------------------------------------

\donttest{
m1$rename_taxa()
}

## ------------------------------------------------
## Method `microtable$merge_samples`
## ------------------------------------------------

\donttest{
m1$merge_samples("Group")
}

## ------------------------------------------------
## Method `microtable$merge_taxa`
## ------------------------------------------------

\donttest{
m1$merge_taxa(taxa = "Genus")
}

## ------------------------------------------------
## Method `microtable$save_table`
## ------------------------------------------------

\dontrun{
m1$save_table()
}

## ------------------------------------------------
## Method `microtable$cal_abund`
## ------------------------------------------------

\donttest{
m1$cal_abund()
}

## ------------------------------------------------
## Method `microtable$save_abund`
## ------------------------------------------------

\dontrun{
m1$save_abund(dirpath = "taxa_abund")
m1$save_abund(merge_all = TRUE, rm_un = TRUE, sep = "\t")
}

## ------------------------------------------------
## Method `microtable$cal_alphadiv`
## ------------------------------------------------

\donttest{
m1$cal_alphadiv(measures = NULL, PD = FALSE)
class(m1$alpha_diversity)
}

## ------------------------------------------------
## Method `microtable$cal_betadiv`
## ------------------------------------------------

\donttest{
m1$cal_betadiv(unifrac = FALSE)
class(m1$beta_diversity)
}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-microtable-new}{\code{microtable$new()}}
\item \href{#method-microtable-filter_pollution}{\code{microtable$filter_pollution()}}
\item \href{#method-microtable-filter_taxa}{\code{microtable$filter_taxa()}}
\item \href{#method-microtable-rarefy_samples}{\code{microtable$rarefy_samples()}}
\item \href{#method-microtable-tidy_dataset}{\code{microtable$tidy_dataset()}}
\item \href{#method-microtable-add_rownames2taxonomy}{\code{microtable$add_rownames2taxonomy()}}
\item \href{#method-microtable-sample_sums}{\code{microtable$sample_sums()}}
\item \href{#method-microtable-taxa_sums}{\code{microtable$taxa_sums()}}
\item \href{#method-microtable-sample_names}{\code{microtable$sample_names()}}
\item \href{#method-microtable-taxa_names}{\code{microtable$taxa_names()}}
\item \href{#method-microtable-rename_taxa}{\code{microtable$rename_taxa()}}
\item \href{#method-microtable-merge_samples}{\code{microtable$merge_samples()}}
\item \href{#method-microtable-merge_taxa}{\code{microtable$merge_taxa()}}
\item \href{#method-microtable-save_table}{\code{microtable$save_table()}}
\item \href{#method-microtable-cal_abund}{\code{microtable$cal_abund()}}
\item \href{#method-microtable-save_abund}{\code{microtable$save_abund()}}
\item \href{#method-microtable-cal_alphadiv}{\code{microtable$cal_alphadiv()}}
\item \href{#method-microtable-save_alphadiv}{\code{microtable$save_alphadiv()}}
\item \href{#method-microtable-cal_betadiv}{\code{microtable$cal_betadiv()}}
\item \href{#method-microtable-save_betadiv}{\code{microtable$save_betadiv()}}
\item \href{#method-microtable-print}{\code{microtable$print()}}
\item \href{#method-microtable-clone}{\code{microtable$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-microtable-new"></a>}}
\if{latex}{\out{\hypertarget{method-microtable-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$new(
  otu_table,
  sample_table = NULL,
  tax_table = NULL,
  phylo_tree = NULL,
  rep_fasta = NULL,
  auto_tidy = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{otu_table}}{data.frame; The feature abundance table; rownames are features (e.g. OTUs/ASVs/species/genes); column names are samples.}

\item{\code{sample_table}}{data.frame; default NULL; The sample information table; rownames are samples; columns are sample metadata; 
If not provided, the function can generate a table automatically according to the sample names in otu_table.}

\item{\code{tax_table}}{data.frame; default NULL; The taxonomic information table; rownames are features; column names are taxonomic classes.}

\item{\code{phylo_tree}}{phylo; default NULL; The phylogenetic tree that must be read with the \code{read.tree} function of ape package.}

\item{\code{rep_fasta}}{\code{DNAStringSet}, \code{list} or \code{DNAbin} format; default NULL; The sequences.
The sequences should be read with the \code{readDNAStringSet} function in \code{Biostrings} package (DNAStringSet class), 
\code{read.fasta} function in \code{seqinr} package (list class),
or \code{read.FASTA} function in \code{ape} package (DNAbin class).}

\item{\code{auto_tidy}}{default FALSE; Whether tidy the files in the \code{microtable} object automatically.
If TRUE, the function can invoke the \code{tidy_dataset} function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object of class \code{microtable} with the following components:
\describe{
  \item{\code{sample_table}}{The sample information table.}
  \item{\code{otu_table}}{The feature table.}
  \item{\code{tax_table}}{The taxonomic table.}
  \item{\code{phylo_tree}}{The phylogenetic tree.}
  \item{\code{rep_fasta}}{The sequence.}
  \item{\code{taxa_abund}}{default NULL; use \code{cal_abund} function to calculate.}
  \item{\code{alpha_diversity}}{default NULL; use \code{cal_alphadiv} function to calculate.}
  \item{\code{beta_diversity}}{default NULL; use \code{cal_betadiv} function to calculate.}
}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data(otu_table_16S)
data(taxonomy_table_16S)
data(sample_info_16S)
data(phylo_tree_16S)
m1 <- microtable$new(otu_table = otu_table_16S)
m1 <- microtable$new(sample_table = sample_info_16S, otu_table = otu_table_16S, 
  tax_table = taxonomy_table_16S, phylo_tree = phylo_tree_16S)
# trim the files in the dataset
m1$tidy_dataset()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-microtable-filter_pollution"></a>}}
\if{latex}{\out{\hypertarget{method-microtable-filter_pollution}{}}}
\subsection{Method \code{filter_pollution()}}{
Filter the features considered pollution in \code{microtable$tax_table}.
This operation will remove any line of the \code{microtable$tax_table} containing any the word in taxa parameter regardless of word case.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$filter_pollution(taxa = c("mitochondria", "chloroplast"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{taxa}}{default \code{c("mitochondria", "chloroplast")}; filter mitochondria and chloroplast, or others as needed.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{m1$filter_pollution(taxa = c("mitochondria", "chloroplast"))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-microtable-filter_taxa"></a>}}
\if{latex}{\out{\hypertarget{method-microtable-filter_taxa}{}}}
\subsection{Method \code{filter_taxa()}}{
Filter the feature with low abundance and/or low occurrence frequency.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$filter_taxa(rel_abund = 0, freq = 1, include_lowest = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rel_abund}}{default 0; the relative abundance threshold, such as 0.0001.}

\item{\code{freq}}{default 1; the occurrence frequency threshold. 
For example, the number 2 represents filtering the feature that occurs less than 2 times.
A number smaller than 1 is also allowable. 
For instance, the number 0.1 represents filtering the feature that occurs in less than 10\% samples.}

\item{\code{include_lowest}}{default TRUE; whether include the feature with the threshold.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
d1 <- clone(m1)
d1$filter_taxa(rel_abund = 0.0001, freq = 0.2)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-microtable-rarefy_samples"></a>}}
\if{latex}{\out{\hypertarget{method-microtable-rarefy_samples}{}}}
\subsection{Method \code{rarefy_samples()}}{
Rarefy communities to make all samples have same count number.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$rarefy_samples(
  method = c("rarefy", "SRS")[1],
  sample.size = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{default c("rarefy", "SRS")[1]; "rarefy" represents the classical resampling like \code{rrarefy} function of \code{vegan} package.
"SRS" is scaling with ranked subsampling method based on the SRS package provided by Lukas Beule and Petr Karlovsky (2020) <DOI:10.7717/peerj.9593>.}

\item{\code{sample.size}}{default NULL; libray size. If not provided, use the minimum number across all samples. 
For "SRS" method, this parameter is passed to \code{Cmin} parameter of \code{SRS} function of SRS package.}

\item{\code{...}}{parameters pass to \code{norm} function of \code{\link{trans_norm}} class.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None; rarefied dataset.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
m1$rarefy_samples(sample.size = min(m1$sample_sums()))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-microtable-tidy_dataset"></a>}}
\if{latex}{\out{\hypertarget{method-microtable-tidy_dataset}{}}}
\subsection{Method \code{tidy_dataset()}}{
Trim all the data in the \code{microtable} object to make taxa and samples consistent. The results are intersections across data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$tidy_dataset(main_data = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{main_data}}{default FALSE; if TRUE, only basic data in \code{microtable} object is trimmed. Otherwise, all data, 
including \code{taxa_abund}, \code{alpha_diversity} and \code{beta_diversity}, are all trimed.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None. The data in the object are tidied up. 
	  If \code{tax_table} is in object, its row names are totally same with the row names of \code{otu_table}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{m1$tidy_dataset(main_data = TRUE)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-microtable-add_rownames2taxonomy"></a>}}
\if{latex}{\out{\hypertarget{method-microtable-add_rownames2taxonomy}{}}}
\subsection{Method \code{add_rownames2taxonomy()}}{
Add the rownames of \code{microtable$tax_table} as its last column. 
This is especially useful when the rownames of \code{microtable$tax_table} are required as a taxonomic level 
	 for the taxonomic abundance calculation and biomarker idenfification.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$add_rownames2taxonomy(use_name = "OTU")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{use_name}}{default "OTU"; The column name used in the \code{tax_table}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL, a new tax_table stored in the object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
m1$add_rownames2taxonomy()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-microtable-sample_sums"></a>}}
\if{latex}{\out{\hypertarget{method-microtable-sample_sums}{}}}
\subsection{Method \code{sample_sums()}}{
Sum the species number for each sample.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$sample_sums()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
species number of samples.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
m1$sample_sums()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-microtable-taxa_sums"></a>}}
\if{latex}{\out{\hypertarget{method-microtable-taxa_sums}{}}}
\subsection{Method \code{taxa_sums()}}{
Sum the species number for each taxa.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$taxa_sums()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
species number of taxa.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
m1$taxa_sums()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-microtable-sample_names"></a>}}
\if{latex}{\out{\hypertarget{method-microtable-sample_names}{}}}
\subsection{Method \code{sample_names()}}{
Show sample names.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$sample_names()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
sample names.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
m1$sample_names()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-microtable-taxa_names"></a>}}
\if{latex}{\out{\hypertarget{method-microtable-taxa_names}{}}}
\subsection{Method \code{taxa_names()}}{
Show taxa names of tax_table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$taxa_names()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
taxa names.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
m1$taxa_names()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-microtable-rename_taxa"></a>}}
\if{latex}{\out{\hypertarget{method-microtable-rename_taxa}{}}}
\subsection{Method \code{rename_taxa()}}{
Rename the features, including the rownames of \code{otu_table}, rownames of \code{tax_table}, tip labels of \code{phylo_tree} and \code{rep_fasta}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$rename_taxa(newname_prefix = "ASV_")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{newname_prefix}}{default "ASV_"; the prefix of new names; new names will be newname_prefix + numbers according to the rownames order of \code{otu_table}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None; renamed dataset.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
m1$rename_taxa()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-microtable-merge_samples"></a>}}
\if{latex}{\out{\hypertarget{method-microtable-merge_samples}{}}}
\subsection{Method \code{merge_samples()}}{
Merge samples according to specific group to generate a new \code{microtable}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$merge_samples(group)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{group}}{a column name in \code{sample_table} of \code{microtable} object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a new merged microtable object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
m1$merge_samples("Group")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-microtable-merge_taxa"></a>}}
\if{latex}{\out{\hypertarget{method-microtable-merge_taxa}{}}}
\subsection{Method \code{merge_taxa()}}{
Merge taxa according to specific taxonomic rank to generate a new \code{microtable}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$merge_taxa(taxa = "Genus")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{taxa}}{default "Genus"; the specific rank in \code{tax_table}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a new merged \code{microtable} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
m1$merge_taxa(taxa = "Genus")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-microtable-save_table"></a>}}
\if{latex}{\out{\hypertarget{method-microtable-save_table}{}}}
\subsection{Method \code{save_table()}}{
Save each basic data in microtable object as local file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$save_table(dirpath = "basic_files", sep = ",", ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dirpath}}{default "basic_files"; directory to save the tables, phylogenetic tree and sequences in microtable object. It will be created if not found.}

\item{\code{sep}}{default ","; the field separator string, used to save tables. Same with \code{sep} parameter in \code{\link{write.table}} function.
default \code{','} correspond to the file name suffix 'csv'. The option \code{'\t'} correspond to the file name suffix 'tsv'. For other options, suffix are all 'txt'.}

\item{\code{...}}{parameters passed to \code{\link{write.table}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
m1$save_table()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-microtable-cal_abund"></a>}}
\if{latex}{\out{\hypertarget{method-microtable-cal_abund}{}}}
\subsection{Method \code{cal_abund()}}{
Calculate the taxonomic abundance at each taxonomic level or selected levels.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$cal_abund(
  select_cols = NULL,
  rel = TRUE,
  merge_by = "|",
  split_group = FALSE,
  split_by = "&",
  split_column = NULL,
  split_special_char = "&&"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{select_cols}}{default NULL; numeric vector (column sequences) or character vector (column names of \code{microtable$tax_table}); 
applied to select columns to calculate abundances according to ordered hierarchical levels.
This parameter is very useful when only part of the columns are needed to calculate abundances.}

\item{\code{rel}}{default TRUE; if TRUE, relative abundance is used; if FALSE, absolute abundance (i.e. raw values) will be summed.}

\item{\code{merge_by}}{default "|"; the symbol to merge and concatenate taxonomic names of different levels.}

\item{\code{split_group}}{default FALSE; if TRUE, split the rows to multiple rows according to one or more columns in \code{tax_table} 
when there is multiple mapping information.}

\item{\code{split_by}}{default "&"; Separator delimiting collapsed values; only available when \code{split_group = TRUE}.}

\item{\code{split_column}}{default NULL; one column name used for the splitting in tax_table for each abundance calculation; 
only available when \code{split_group = TRUE}. If not provided, the function will split each column that containing the \code{split_by} character.}

\item{\code{split_special_char}}{default "&&"; special character that will be used forcibly to split multiple mapping information in \code{tax_table} by default
no matter \code{split_group} setting.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{taxa_abund} list in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
m1$cal_abund()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-microtable-save_abund"></a>}}
\if{latex}{\out{\hypertarget{method-microtable-save_abund}{}}}
\subsection{Method \code{save_abund()}}{
Save taxonomic abundance as local file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$save_abund(
  dirpath = "taxa_abund",
  merge_all = FALSE,
  rm_un = FALSE,
  rm_pattern = "__$",
  sep = ",",
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dirpath}}{default "taxa_abund"; directory to save the taxonomic abundance files. It will be created if not found.}

\item{\code{merge_all}}{default FALSE; Whether merge all tables into one. The merged file format is generally called 'mpa' style.}

\item{\code{rm_un}}{default FALSE; Whether remove unclassified taxa in which the name ends with '__' generally.}

\item{\code{rm_pattern}}{default "__$"; The pattern searched through the merged taxonomic names. See also \code{pattern} parameter in \code{\link{grepl}} function. 
Only available when \code{rm_un = TRUE}. The default "__$" means removing the names end with '__'.}

\item{\code{sep}}{default ","; the field separator string. Same with \code{sep} parameter in \code{\link{write.table}} function.
default \code{','} correspond to the file name suffix 'csv'. The option \code{'\t'} correspond to the file name suffix 'tsv'. For other options, suffix are all 'txt'.}

\item{\code{...}}{parameters passed to \code{\link{write.table}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
m1$save_abund(dirpath = "taxa_abund")
m1$save_abund(merge_all = TRUE, rm_un = TRUE, sep = "\t")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-microtable-cal_alphadiv"></a>}}
\if{latex}{\out{\hypertarget{method-microtable-cal_alphadiv}{}}}
\subsection{Method \code{cal_alphadiv()}}{
Calculate alpha diversity.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$cal_alphadiv(measures = NULL, PD = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{measures}}{default NULL; one or more indexes in \code{c("Observed", "Coverage", "Chao1", "ACE", "Shannon", "Simpson", "InvSimpson", "Fisher", "Pielou")}; 
The default NULL represents that all the measures are calculated. 'Shannon', 'Simpson' and 'InvSimpson' are calculated based on \code{vegan::diversity} function;
'Chao1' and 'ACE' depend on the function \code{vegan::estimateR}.
'Fisher' index relies on the function \code{vegan::fisher.alpha}.
"Observed" means the observed species number in a community, i.e. richness.
"Coverage" represents good's coverage. It is defined:
              \deqn{Coverage = 1 - \frac{f1}{n}} 
 where \emph{n} is the total abundance of a sample, and \emph{f1} is the number of singleton (species with abundance 1) in the sample.
"Pielou" denotes the Pielou evenness index. It is defined:
              \deqn{J = \frac{H'}{\ln(S)}}
 where \emph{H'} is Shannon index, and \emph{S} is the species number.}

\item{\code{PD}}{default FALSE; whether Faith's phylogenetic diversity is calculated. The calculation depends on the function \code{picante::pd}.
Note that the phylogenetic tree (\code{phylo_tree} object in the data) is required for PD.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
alpha_diversity stored in the object. The se.chao1 and se.ACE are the standard erros of Chao1 and ACE, respectively.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
m1$cal_alphadiv(measures = NULL, PD = FALSE)
class(m1$alpha_diversity)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-microtable-save_alphadiv"></a>}}
\if{latex}{\out{\hypertarget{method-microtable-save_alphadiv}{}}}
\subsection{Method \code{save_alphadiv()}}{
Save alpha diversity table to the computer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$save_alphadiv(dirpath = "alpha_diversity")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dirpath}}{default "alpha_diversity"; directory name to save the alpha_diversity.csv file.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-microtable-cal_betadiv"></a>}}
\if{latex}{\out{\hypertarget{method-microtable-cal_betadiv}{}}}
\subsection{Method \code{cal_betadiv()}}{
Calculate beta diversity dissimilarity matrix, such as Bray-Curtis, Jaccard, and UniFrac.
See An et al. (2019) <doi:10.1016/j.geoderma.2018.09.035> and Lozupone et al. (2005) <doi:10.1128/AEM.71.12.8228–8235.2005>.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$cal_betadiv(method = NULL, unifrac = FALSE, binary = FALSE, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{default NULL; a character vector with one or more elements; \code{c("bray", "jaccard")} is used when \code{method = NULL}; 
See the \code{method} parameter in \code{vegdist} function for more available options, such as 'aitchison' and 'robust.aitchison'.}

\item{\code{unifrac}}{default FALSE; whether UniFrac indexes (weighted and unweighted) are calculated. Phylogenetic tree is necessary when \code{unifrac = TRUE}.}

\item{\code{binary}}{default FALSE; Whether convert abundance to binary data (presence/absence) when \code{method} is not "jaccard". 
TRUE is used for "jaccard" automatically.}

\item{\code{...}}{parameters passed to \code{vegdist} function of vegan package.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
beta_diversity list stored in the object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
m1$cal_betadiv(unifrac = FALSE)
class(m1$beta_diversity)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-microtable-save_betadiv"></a>}}
\if{latex}{\out{\hypertarget{method-microtable-save_betadiv}{}}}
\subsection{Method \code{save_betadiv()}}{
Save beta diversity matrix to the computer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$save_betadiv(dirpath = "beta_diversity")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dirpath}}{default "beta_diversity"; directory name to save the beta diversity matrix files.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-microtable-print"></a>}}
\if{latex}{\out{\hypertarget{method-microtable-print}{}}}
\subsection{Method \code{print()}}{
Print the microtable object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-microtable-clone"></a>}}
\if{latex}{\out{\hypertarget{method-microtable-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{microtable$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
