% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_abund.R
\name{trans_abund}
\alias{trans_abund}
\title{Create \code{trans_abund} object for plotting taxonomic abundance.}
\description{
This class is a wrapper for the taxonomic abundance transformations and visualization.
The converted data style is the long-format for \code{ggplot2} plot.
The plotting methods include bar plot, boxplot, heatmap, pie chart and line chart.
}
\examples{

## ------------------------------------------------
## Method `trans_abund$new`
## ------------------------------------------------

\donttest{
data(dataset)
t1 <- trans_abund$new(dataset = dataset, taxrank = "Phylum", ntaxa = 10)
}

## ------------------------------------------------
## Method `trans_abund$plot_bar`
## ------------------------------------------------

\donttest{
t1$plot_bar(facet = "Group", xtext_keep = FALSE)
}

## ------------------------------------------------
## Method `trans_abund$plot_heatmap`
## ------------------------------------------------

\donttest{
t1 <- trans_abund$new(dataset = dataset, taxrank = "Genus", ntaxa = 40)
t1$plot_heatmap(facet = "Group", xtext_keep = FALSE, withmargin = FALSE)
}

## ------------------------------------------------
## Method `trans_abund$plot_box`
## ------------------------------------------------

\donttest{
t1$plot_box(group = "Group")
}

## ------------------------------------------------
## Method `trans_abund$plot_line`
## ------------------------------------------------

\donttest{
t1 <- trans_abund$new(dataset = dataset, taxrank = "Genus", ntaxa = 5)
t1$plot_line(point_size = 3)
t1 <- trans_abund$new(dataset = dataset, taxrank = "Genus", ntaxa = 5, groupmean = "Group")
t1$plot_line(point_size = 5, errorbar_size = 1, xtext_angle = 30)
}

## ------------------------------------------------
## Method `trans_abund$plot_pie`
## ------------------------------------------------

\donttest{
t1 <- trans_abund$new(dataset = dataset, taxrank = "Phylum", ntaxa = 6, groupmean = "Group")
t1$plot_pie(facet_nrow = 1)
}

## ------------------------------------------------
## Method `trans_abund$plot_donut`
## ------------------------------------------------

\dontrun{
t1 <- trans_abund$new(dataset = dataset, taxrank = "Phylum", ntaxa = 6, groupmean = "Group")
t1$plot_donut(label = TRUE)
}

## ------------------------------------------------
## Method `trans_abund$plot_radar`
## ------------------------------------------------

\dontrun{
t1 <- trans_abund$new(dataset = dataset, taxrank = "Phylum", ntaxa = 6, groupmean = "Group")
t1$plot_radar()
}

## ------------------------------------------------
## Method `trans_abund$plot_tern`
## ------------------------------------------------

\dontrun{
t1 <- trans_abund$new(dataset = dataset, taxrank = "Phylum", ntaxa = 6, groupmean = "Group")
t1$plot_tern()
}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-trans_abund-new}{\code{trans_abund$new()}}
\item \href{#method-trans_abund-plot_bar}{\code{trans_abund$plot_bar()}}
\item \href{#method-trans_abund-plot_heatmap}{\code{trans_abund$plot_heatmap()}}
\item \href{#method-trans_abund-plot_box}{\code{trans_abund$plot_box()}}
\item \href{#method-trans_abund-plot_line}{\code{trans_abund$plot_line()}}
\item \href{#method-trans_abund-plot_pie}{\code{trans_abund$plot_pie()}}
\item \href{#method-trans_abund-plot_donut}{\code{trans_abund$plot_donut()}}
\item \href{#method-trans_abund-plot_radar}{\code{trans_abund$plot_radar()}}
\item \href{#method-trans_abund-plot_tern}{\code{trans_abund$plot_tern()}}
\item \href{#method-trans_abund-print}{\code{trans_abund$print()}}
\item \href{#method-trans_abund-clone}{\code{trans_abund$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_abund-new"></a>}}
\if{latex}{\out{\hypertarget{method-trans_abund-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_abund$new(
  dataset = NULL,
  taxrank = "Phylum",
  show = 0,
  ntaxa = 10,
  groupmean = NULL,
  group_morestats = FALSE,
  delete_taxonomy_lineage = TRUE,
  delete_taxonomy_prefix = TRUE,
  prefix = NULL,
  use_percentage = TRUE,
  input_taxaname = NULL,
  high_level = NULL,
  high_level_fix_nsub = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataset}}{default NULL; the object of \code{\link{microtable}} class.}

\item{\code{taxrank}}{default "Phylum"; taxonomic rank.}

\item{\code{show}}{default 0; the relative abundance threshold for filtering the taxa with low abundance.}

\item{\code{ntaxa}}{default 10; how many taxa are selected to show. Taxa are ordered by abundance from high to low. 
This parameter does not conflict with the parameter \code{show}. Both can be used. \code{ntaxa = NULL} means it is unavailable.}

\item{\code{groupmean}}{default NULL; calculate mean abundance for each group. Select a column name in \code{microtable$sample_table}.}

\item{\code{group_morestats}}{default FALSE; only available when \code{groupmean} parameter is provided; 
Whether output more statistics for each group, including min, max, median and quantile;
Thereinto, quantile25 and quantile75 denote 25\% and 75\% quantiles, respectively.}

\item{\code{delete_taxonomy_lineage}}{default TRUE; whether delete the taxonomy lineage in front of the target level.}

\item{\code{delete_taxonomy_prefix}}{default TRUE; whether delete the prefix of taxonomy, such as "g__".}

\item{\code{prefix}}{default NULL; character string; available when \code{delete_taxonomy_prefix = T}; 
default NULL reprensents using the "letter+__", e.g. "k__" for Phylum level;
Please provide the customized prefix when it is not standard, otherwise the program can not correctly recognize it.}

\item{\code{use_percentage}}{default TRUE; show the abundance percentage.}

\item{\code{input_taxaname}}{default NULL; character vector; input taxa names for selecting some taxa.}

\item{\code{high_level}}{default NULL; a taxonomic rank, such as "Phylum", used to add the taxonomic information of higher level.
It is necessary for the legend with nested taxonomic levels in the bar plot.}

\item{\code{high_level_fix_nsub}}{default NULL; an integer, used to fix the number of selected abundant taxa in each taxon from higher taxonomic level.
If the total number under one taxon of higher level is less than the high_level_fix_nsub, the total number will be used.
When \code{high_level_fix_nsub} is provided, the taxa number of higher level is calculated as: \code{ceiling(ntaxa/high_level_fix_nsub)}.
Note that \code{ntaxa} means either the parameter \code{ntaxa} or the taxonomic number obtained by filtering according to the \code{show} parameter.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{data_abund} stored in the object. The column 'all_mean_abund' reprensents mean relative abundance across all the samples.
  So the values in one taxon are all same across all the samples.
  If the sum of column 'Abundance' in one sample is larger than 1, the 'Abundance', 'SD' and 'SE' has been multiplied by 100.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
data(dataset)
t1 <- trans_abund$new(dataset = dataset, taxrank = "Phylum", ntaxa = 10)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_abund-plot_bar"></a>}}
\if{latex}{\out{\hypertarget{method-trans_abund-plot_bar}{}}}
\subsection{Method \code{plot_bar()}}{
Bar plot.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_abund$plot_bar(
  color_values = RColorBrewer::brewer.pal(8, "Dark2"),
  bar_type = "full",
  others_color = "grey90",
  facet = NULL,
  order_x = NULL,
  x_axis_name = NULL,
  barwidth = NULL,
  use_alluvium = FALSE,
  clustering = FALSE,
  clustering_plot = FALSE,
  cluster_plot_width = 0.2,
  facet_color = "grey95",
  strip_text = 11,
  legend_text_italic = FALSE,
  xtext_angle = 0,
  xtext_size = 10,
  xtext_keep = TRUE,
  xtitle_keep = TRUE,
  ytitle_size = 17,
  coord_flip = FALSE,
  ggnested = FALSE,
  high_level_add_other = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{color_values}}{default \code{RColorBrewer::brewer.pal}(8, "Dark2"); colors palette for the bars.}

\item{\code{bar_type}}{default "full"; "full" or "notfull"; if \code{"full"}, total abundance are summed to 1 or 100 percentage.}

\item{\code{others_color}}{default "grey90"; the color for "others" taxa.}

\item{\code{facet}}{default NULL; a character vector for the facet; group column name of \code{sample_table}, such as, \code{"Group"};
If multiple facets are needed, please provide ordered names, such as \code{c("Group", "Type")}.
The latter should have a finer scale than the former one;
Please adjust the facet orders in the plot by assigning factors in \code{sample_table} before creating \code{trans_abund} object or 
assigning factors in the \code{data_abund} table of \code{trans_abund} object.
When multiple facets are used, please first install package \code{ggh4x} using the command \code{install.packages("ggh4x")}.}

\item{\code{order_x}}{default NULL; vector; used to order the sample names in x axis; must be the samples vector, such as \code{c("S1", "S3", "S2")}.}

\item{\code{x_axis_name}}{NULL; a character string; a column name of sample_table in dataset; used to show the sample names in x axis.}

\item{\code{barwidth}}{default NULL; bar width, see \code{width} in \code{\link{geom_bar}}.}

\item{\code{use_alluvium}}{default FALSE; whether add alluvium plot. If \code{TRUE}, please first install \code{ggalluvial} package.}

\item{\code{clustering}}{default FALSE; whether order samples by the clustering.}

\item{\code{clustering_plot}}{default FALSE; whether add clustering plot.
If \code{clustering_plot = TRUE}, \code{clustering} will be also TRUE in any case for the clustering.}

\item{\code{cluster_plot_width}}{default 0.2, the dendrogram plot width; available when \code{clustering_plot = TRUE}.}

\item{\code{facet_color}}{default "grey95"; facet background color.}

\item{\code{strip_text}}{default 11; facet text size.}

\item{\code{legend_text_italic}}{default FALSE; whether use italic in legend.}

\item{\code{xtext_angle}}{default 0; number ranging from 0 to 90; used to adjust x axis text angle to reduce text overlap;}

\item{\code{xtext_size}}{default 10; x axis text size.}

\item{\code{xtext_keep}}{default TRUE; whether retain x text.}

\item{\code{xtitle_keep}}{default TRUE; whether retain x title.}

\item{\code{ytitle_size}}{default 17; y axis title size.}

\item{\code{coord_flip}}{default FALSE; whether flip cartesian coordinates so that horizontal becomes vertical, and vertical becomes horizontal.}

\item{\code{ggnested}}{default FALSE; whether use nested legend. Need \code{ggnested} package to be installed (https://github.com/gmteunisse/ggnested).
To make it available, please assign \code{high_level} parameter when creating the object.}

\item{\code{high_level_add_other}}{default FALSE; whether add 'Others' (all the unknown taxa) in each taxon of higher taxonomic level.
Only available when \code{ggnested = TRUE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot2 object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$plot_bar(facet = "Group", xtext_keep = FALSE)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_abund-plot_heatmap"></a>}}
\if{latex}{\out{\hypertarget{method-trans_abund-plot_heatmap}{}}}
\subsection{Method \code{plot_heatmap()}}{
Plot the heatmap.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_abund$plot_heatmap(
  color_values = rev(RColorBrewer::brewer.pal(n = 11, name = "RdYlBu")),
  facet = NULL,
  x_axis_name = NULL,
  order_x = NULL,
  withmargin = TRUE,
  plot_numbers = FALSE,
  plot_text_size = 4,
  plot_breaks = NULL,
  margincolor = "white",
  plot_colorscale = "log10",
  min_abundance = 0.01,
  max_abundance = NULL,
  strip_text = 11,
  xtext_size = 10,
  ytext_size = 11,
  xtext_keep = TRUE,
  xtitle_keep = TRUE,
  grid_clean = TRUE,
  xtext_angle = 0,
  legend_title = "\% Relative\\nAbundance",
  pheatmap = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{color_values}}{default rev(RColorBrewer::brewer.pal(n = 11, name = "RdYlBu")); 
colors palette for the plotting.}

\item{\code{facet}}{default NULL; a character vector for the facet; a group column name of \code{sample_table}, such as, \code{"Group"};
If multiple facets are needed, please provide ordered names, such as \code{c("Group", "Type")}.
The latter should have a finer scale than the former one;
Please adjust the facet orders in the plot by assigning factors in \code{sample_table} before creating \code{trans_abund} object or 
assigning factors in the \code{data_abund} table of \code{trans_abund} object.
When multiple facets are used, please first install package \code{ggh4x} using the command \code{install.packages("ggh4x")}.}

\item{\code{x_axis_name}}{NULL; a character string; a column name of sample_table used to show the sample names in x axis.}

\item{\code{order_x}}{default NULL; vector; used to order the sample names in x axis; must be the samples vector, such as, c("S1", "S3", "S2").}

\item{\code{withmargin}}{default TRUE; whether retain the tile margin.}

\item{\code{plot_numbers}}{default FALSE; whether plot the number in heatmap.}

\item{\code{plot_text_size}}{default 4; If plot_numbers TRUE, text size in plot.}

\item{\code{plot_breaks}}{default NULL; The legend breaks.}

\item{\code{margincolor}}{default "white"; If withmargin TRUE, use this as the margin color.}

\item{\code{plot_colorscale}}{default "log10"; color scale.}

\item{\code{min_abundance}}{default .01; the minimum abundance percentage in plot.}

\item{\code{max_abundance}}{default NULL; the maximum abundance percentage in plot, NULL reprensent the max percentage.}

\item{\code{strip_text}}{default 11; facet text size.}

\item{\code{xtext_size}}{default 10; x axis text size.}

\item{\code{ytext_size}}{default 11; y axis text size.}

\item{\code{xtext_keep}}{default TRUE; whether retain x text.}

\item{\code{xtitle_keep}}{default TRUE; whether retain x title.}

\item{\code{grid_clean}}{default TRUE; whether remove grid lines.}

\item{\code{xtext_angle}}{default 0; number ranging from 0 to 90; used to adjust x axis text angle to reduce text overlap;}

\item{\code{legend_title}}{default "\% Relative\\nAbundance"; legend title text.}

\item{\code{pheatmap}}{default FALSE; whether use pheatmap package to plot the heatmap.}

\item{\code{...}}{paremeters pass to pheatmap when pheatmap = TRUE.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot2 object or grid object based on pheatmap.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1 <- trans_abund$new(dataset = dataset, taxrank = "Genus", ntaxa = 40)
t1$plot_heatmap(facet = "Group", xtext_keep = FALSE, withmargin = FALSE)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_abund-plot_box"></a>}}
\if{latex}{\out{\hypertarget{method-trans_abund-plot_box}{}}}
\subsection{Method \code{plot_box()}}{
Box plot.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_abund$plot_box(
  color_values = RColorBrewer::brewer.pal(8, "Dark2"),
  group = NULL,
  show_point = FALSE,
  point_color = "black",
  point_size = 3,
  point_alpha = 0.3,
  plot_flip = FALSE,
  boxfill = TRUE,
  middlecolor = "grey95",
  middlesize = 1,
  xtext_angle = 0,
  xtext_size = 10,
  ytitle_size = 17,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{color_values}}{default \code{RColorBrewer::brewer.pal}(8, "Dark2"); colors palette for the box.}

\item{\code{group}}{default NULL; a column name of sample table to show abundance across groups.}

\item{\code{show_point}}{default FALSE; whether show points in plot.}

\item{\code{point_color}}{default "black"; If show_point TRUE; use the color}

\item{\code{point_size}}{default 3; If show_point TRUE; use the size}

\item{\code{point_alpha}}{default .3; If show_point TRUE; use the transparency.}

\item{\code{plot_flip}}{default FALSE; Whether rotate plot.}

\item{\code{boxfill}}{default TRUE; Whether fill the box with colors.}

\item{\code{middlecolor}}{default "grey95"; The middle line color.}

\item{\code{middlesize}}{default 1; The middle line size.}

\item{\code{xtext_angle}}{default 0; number ranging from 0 to 90; used to adjust x axis text angle to reduce text overlap;}

\item{\code{xtext_size}}{default 10; x axis text size.}

\item{\code{ytitle_size}}{default 17; y axis title size.}

\item{\code{...}}{parameters pass to \code{\link{geom_boxplot}} function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot2 object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$plot_box(group = "Group")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_abund-plot_line"></a>}}
\if{latex}{\out{\hypertarget{method-trans_abund-plot_line}{}}}
\subsection{Method \code{plot_line()}}{
Plot the line chart.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_abund$plot_line(
  color_values = RColorBrewer::brewer.pal(8, "Dark2"),
  plot_SE = TRUE,
  position = position_dodge(0.1),
  errorbar_size = 1,
  errorbar_width = 0.1,
  point_size = 3,
  point_alpha = 0.8,
  line_size = 0.8,
  line_alpha = 0.8,
  line_type = 1,
  xtext_angle = 0,
  xtext_size = 10,
  ytitle_size = 17
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{color_values}}{default \code{RColorBrewer::brewer.pal}(8, "Dark2"); colors palette for the points and lines.}

\item{\code{plot_SE}}{default TRUE; TRUE: the errorbar is \eqn{mean±se}; FALSE: the errorbar is \eqn{mean±sd}.}

\item{\code{position}}{default position_dodge(0.1); Position adjustment, either as a string (such as "identity"), or the result of a call to a position adjustment function.}

\item{\code{errorbar_size}}{default 1; errorbar size.}

\item{\code{errorbar_width}}{default 0.1; errorbar width.}

\item{\code{point_size}}{default 3; point size for taxa.}

\item{\code{point_alpha}}{default 0.8; point transparency.}

\item{\code{line_size}}{default 0.8; line size.}

\item{\code{line_alpha}}{default 0.8; line transparency.}

\item{\code{line_type}}{default 1; an integer; line type.}

\item{\code{xtext_angle}}{default 0; number ranging from 0 to 90; used to adjust x axis text angle to reduce text overlap;}

\item{\code{xtext_size}}{default 10; x axis text size.}

\item{\code{ytitle_size}}{default 17; y axis title size.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot2 object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1 <- trans_abund$new(dataset = dataset, taxrank = "Genus", ntaxa = 5)
t1$plot_line(point_size = 3)
t1 <- trans_abund$new(dataset = dataset, taxrank = "Genus", ntaxa = 5, groupmean = "Group")
t1$plot_line(point_size = 5, errorbar_size = 1, xtext_angle = 30)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_abund-plot_pie"></a>}}
\if{latex}{\out{\hypertarget{method-trans_abund-plot_pie}{}}}
\subsection{Method \code{plot_pie()}}{
Pie chart.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_abund$plot_pie(
  color_values = RColorBrewer::brewer.pal(8, "Dark2"),
  facet_nrow = 1,
  strip_text = 11,
  add_label = FALSE,
  legend_text_italic = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{color_values}}{default \code{RColorBrewer::brewer.pal}(8, "Dark2"); colors palette for each section.}

\item{\code{facet_nrow}}{default 1; how many rows in the plot.}

\item{\code{strip_text}}{default 11; sample title size.}

\item{\code{add_label}}{default FALSE; Whether add the percentage label in each section of pie chart.}

\item{\code{legend_text_italic}}{default FALSE; whether use italic in legend.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot2 object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1 <- trans_abund$new(dataset = dataset, taxrank = "Phylum", ntaxa = 6, groupmean = "Group")
t1$plot_pie(facet_nrow = 1)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_abund-plot_donut"></a>}}
\if{latex}{\out{\hypertarget{method-trans_abund-plot_donut}{}}}
\subsection{Method \code{plot_donut()}}{
Donut chart based on the \code{ggpubr::ggdonutchart} function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_abund$plot_donut(
  color_values = RColorBrewer::brewer.pal(8, "Dark2"),
  label = TRUE,
  facet_nrow = 1,
  legend_text_italic = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{color_values}}{default \code{RColorBrewer::brewer.pal}(8, "Dark2"); colors palette for the donut.}

\item{\code{label}}{default TRUE; whether show the percentage label.}

\item{\code{facet_nrow}}{default 1; how many rows in the plot.}

\item{\code{legend_text_italic}}{default FALSE; whether use italic in legend.}

\item{\code{...}}{parameters passed to \code{ggpubr::ggdonutchart}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
combined ggplot2 objects list, generated by \code{ggpubr::ggarrange} function.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
t1 <- trans_abund$new(dataset = dataset, taxrank = "Phylum", ntaxa = 6, groupmean = "Group")
t1$plot_donut(label = TRUE)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_abund-plot_radar"></a>}}
\if{latex}{\out{\hypertarget{method-trans_abund-plot_radar}{}}}
\subsection{Method \code{plot_radar()}}{
Radar chart based on the \code{ggradar} package (https://github.com/ricardo-bion/ggradar).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_abund$plot_radar(
  color_values = RColorBrewer::brewer.pal(8, "Dark2"),
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{color_values}}{default \code{RColorBrewer::brewer.pal}(8, "Dark2"); colors palette for samples.}

\item{\code{...}}{parameters passed to \code{ggradar::ggradar} function except group.colours parameter.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot2 object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
t1 <- trans_abund$new(dataset = dataset, taxrank = "Phylum", ntaxa = 6, groupmean = "Group")
t1$plot_radar()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_abund-plot_tern"></a>}}
\if{latex}{\out{\hypertarget{method-trans_abund-plot_tern}{}}}
\subsection{Method \code{plot_tern()}}{
Ternary diagrams based on the \code{ggtern} package.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_abund$plot_tern(
  color_values = RColorBrewer::brewer.pal(8, "Dark2"),
  color_legend_guide_size = 4
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{color_values}}{default \code{RColorBrewer::brewer.pal}(8, "Dark2"); colors palette for the samples.}

\item{\code{color_legend_guide_size}}{default 4; The size of legend guide for color.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot2 object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
t1 <- trans_abund$new(dataset = dataset, taxrank = "Phylum", ntaxa = 6, groupmean = "Group")
t1$plot_tern()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_abund-print"></a>}}
\if{latex}{\out{\hypertarget{method-trans_abund-print}{}}}
\subsection{Method \code{print()}}{
Print the trans_abund object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_abund$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_abund-clone"></a>}}
\if{latex}{\out{\hypertarget{method-trans_abund-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_abund$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
