% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blasting.R
\name{readBlastTable}
\alias{readBlastTable}
\title{Reading BLAST result file}
\usage{
readBlastTable(blast.file)
}
\arguments{
\item{blast.file}{Name of file to read.}
}
\value{
The content of the file is returned as a \samp{data.frame} with 12 columns and one row for each
BLAST result. The columns have self-explanatory names.
}
\description{
Reading a file produced by the BLAST+ software set up to produce tabular output.
}
\details{
This function will read files produced by the BLAST+ software where the option \samp{-outfmt 6}
has been invoked during its call. This option forces BLAST to produce a short tabular text output for
each BLAST search. The function \code{\link{blastAllAll}} produces such files.
}
\examples{
# Using a BLAST result file in this package
xpth <- file.path(path.package("micropan"),"extdata")
blast.file <- file.path( xpth, "GID1_vs_GID2.txt.xz" )

# We need to uncompress it first...
tf <- tempfile(fileext=".xz")
s <- file.copy(blast.file,tf)
tf <- xzuncompress(tf)

#...then we can read it...
blast.table <- readBlastTable(tf)

# ...and deleting temporary file
s <- file.remove(tf)

}
\seealso{
\code{\link{blastAllAll}}, \code{\link{bDist}}.
}
\author{
Lars Snipen and Kristian Hovde Liland.
}
